/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.validator.document;

import com.cognos.validator.api.ValidatorException;
import com.cognos.validator.common.Log;
import com.cognos.validator.common.Message;
import com.cognos.validator.common.Messages;
import com.cognos.validator.document.IDocAgent;
import com.cognos.validator.document.IVerifier;
import com.cognos.validator.document.JavaScriptDocument;
import com.cognos.validator.document.ParserException;
import com.cognos.validator.document.StreamReaderHelper;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class Enumeration
implements Serializable,
IVerifier {
    private static final long serialVersionUID = 988931244726694022L;
    private static final String ELEMENT_LIST = "list";
    private static final String ELEMENT_ITEM = "item";
    private static final String DEFAULT_SEPARATOR = ",";
    private static final String ATTRIBUTE_CASE_SENSITIVE = "caseSensitive";
    private static final String ATTRIBUTE_EMPTY_VALID = "emptyValid";
    private static final String ATTRIBUTE_SEPARATOR = "separator";
    private HashSet m_items = new HashSet();
    private boolean m_caseSensitive = true;
    private boolean m_emptyValid = false;

    Enumeration(XMLStreamReader sr) throws XMLStreamException, ParserException {
        this.readAttributes(sr);
        this.readDefinition(sr);
    }

    private void readAttributes(XMLStreamReader sr) {
        String caseSensitive;
        String emptyValid = sr.getAttributeValue(null, ATTRIBUTE_EMPTY_VALID);
        if (emptyValid != null && emptyValid.equals("true")) {
            this.m_emptyValid = true;
        }
        if ((caseSensitive = sr.getAttributeValue(null, ATTRIBUTE_CASE_SENSITIVE)) != null && caseSensitive.equals("false")) {
            this.m_caseSensitive = false;
        }
    }

    private void readStringList(XMLStreamReader sr) throws XMLStreamException, ParserException {
        String separator = sr.getAttributeValue(null, ATTRIBUTE_SEPARATOR);
        if (separator == null) {
            separator = DEFAULT_SEPARATOR;
        }
        String list = sr.getElementText();
        StringTokenizer st = new StringTokenizer(list, separator);
        String token = null;
        while (st.hasMoreTokens()) {
            token = st.nextToken();
            if (token.length() == 0) {
                throw new ParserException(new Message("enumeration list with empty token"));
            }
            if (!this.m_caseSensitive) {
                token = token.toLowerCase();
            }
            this.m_items.add(token);
        }
        StreamReaderHelper.closeElement(sr);
    }

    private void readItemList(XMLStreamReader sr) throws ParserException, XMLStreamException {
        String item = null;
        do {
            if ((item = sr.getElementText()).length() == 0) {
                throw new ParserException(new Message("enumeration with empty item"));
            }
            if (!this.m_caseSensitive) {
                item = item.toLowerCase();
            }
            this.m_items.add(item);
        } while (StreamReaderHelper.moveToNextSibling(sr, ELEMENT_ITEM));
    }

    private void readDefinition(XMLStreamReader sr) throws XMLStreamException, ParserException {
        if (!StreamReaderHelper.moveToNextSibling(sr)) {
            throw new ParserException(new Message("enumeration without a list"));
        }
        String name = sr.getLocalName();
        if (Log.traceEnabled) {
            Log.trace(new Message("enumeration parsing", "name", name), 10000, "parser");
        }
        if (name.equals(ELEMENT_LIST)) {
            this.readStringList(sr);
        } else {
            if (!name.equals(ELEMENT_ITEM)) {
                throw new ParserException(new Message("invalid enumeration element", "name", name));
            }
            this.readItemList(sr);
        }
    }

    @Override
    public boolean verify(String value, Messages messages, IDocAgent docAgent, int nestingLevel, StringBuffer modifiedValue) throws ValidatorException {
        boolean valid = true;
        if (value.length() == 0) {
            if (!this.m_emptyValid) {
                messages.add(new Message("empty value not valid"));
                valid = false;
            }
        } else {
            String caseValue = value;
            if (!this.m_caseSensitive) {
                caseValue = caseValue.toLowerCase();
            }
            if (!this.m_items.contains(caseValue)) {
                messages.add(new Message("value not found in enumeration"));
                valid = false;
            }
        }
        if (!valid) {
            messages.add(new Message("enumeration verify failed"));
            messages.add(this.description());
        }
        return valid;
    }

    @Override
    public Messages description() {
        return new Messages(new Message("enumeration", "items", this.m_items.toString(), "case sensitive", String.valueOf(this.m_caseSensitive)));
    }

    @Override
    public void asJavaScript(JavaScriptDocument jsDoc, List requiredDef, IDocAgent docAgent) {
        StringBuffer invocation = new StringBuffer(256);
        invocation.append("res = this[\"_enumeration\"](v,");
        invocation.append(this.m_emptyValid ? "true" : "false");
        invocation.append(DEFAULT_SEPARATOR);
        invocation.append(this.m_caseSensitive ? "true" : "false");
        invocation.append(",[");
        Iterator i = this.m_items.iterator();
        String item = null;
        while (i.hasNext()) {
            item = (String)i.next();
            invocation.append("\"");
            invocation.append(item);
            invocation.append("\"");
            if (!i.hasNext()) continue;
            invocation.append(',');
        }
        invocation.append("])");
        jsDoc.addLine(invocation.toString());
    }
}

