/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.validator.document;

import com.cognos.validator.api.ValidatorException;
import com.cognos.validator.common.Message;
import com.cognos.validator.common.Messages;
import com.cognos.validator.document.IDocAgent;
import com.cognos.validator.document.IVerifier;
import com.cognos.validator.document.JavaScriptDocument;
import com.cognos.validator.document.ParserException;
import com.cognos.validator.document.Ref;
import com.cognos.validator.document.StreamReaderHelper;
import java.io.Serializable;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class Global
implements Serializable,
IVerifier {
    private static final long serialVersionUID = -911692750587799403L;
    private static final String ATTRIBUTE_SKIP_JAVASCRIPT = "skipJavaScript";
    private static final String ELEMENT_RULE_REF = "ruleRef";
    private static final String JS_GLOBAL_FUNCTION = "gFunc";
    private Ref m_ref = null;
    private boolean m_skipJavaScript = false;

    Global(XMLStreamReader sr, String namespace) throws XMLStreamException, ParserException, ValidatorException {
        String str = null;
        str = sr.getAttributeValue(null, ATTRIBUTE_SKIP_JAVASCRIPT);
        if (str != null) {
            this.m_skipJavaScript = Boolean.valueOf(str);
        }
        if (!StreamReaderHelper.moveToNextSibling(sr, ELEMENT_RULE_REF)) {
            throw new ParserException(new Message("global without a rule reference"));
        }
        this.m_ref = new Ref(sr, namespace);
        StreamReaderHelper.closeElement(sr);
    }

    @Override
    public boolean verify(String value, Messages messages, IDocAgent docAgent, int nestingLevel, StringBuffer modifiedValue) throws ValidatorException {
        return this.m_ref.verify(value, messages, docAgent, nestingLevel, modifiedValue);
    }

    @Override
    public void asJavaScript(JavaScriptDocument jsDoc, List requiredDefinitions, IDocAgent docAgent) throws ValidatorException {
        if (!this.m_skipJavaScript) {
            int index = docAgent.nextJSGlobalFunctionIndex();
            jsDoc.startFunction(JS_GLOBAL_FUNCTION + String.valueOf(index));
            jsDoc.addLine("var res = 0");
            this.m_ref.asJavaScript(jsDoc, requiredDefinitions, docAgent);
            jsDoc.addLine("return res");
            jsDoc.endFunction();
        }
    }

    @Override
    public Messages description() {
        Messages m = new Messages(new Message("global"));
        m.addChild(this.m_ref.description());
        return m;
    }
}

