/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.validator.document;

import com.cognos.validator.api.ValidatorException;
import com.cognos.validator.common.ExceptionHelper;
import com.cognos.validator.common.Log;
import com.cognos.validator.common.Message;
import com.cognos.validator.common.Messages;
import com.cognos.validator.document.IDocAgent;
import com.cognos.validator.document.IVerifier;
import com.cognos.validator.document.JavaScriptDocument;
import com.cognos.validator.document.ParserException;
import com.cognos.validator.document.Pattern;
import com.cognos.validator.document.Ref;
import com.cognos.validator.document.Rule;
import com.cognos.validator.document.Sign;
import com.cognos.validator.document.StreamReaderHelper;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class Parameter
implements Serializable,
IVerifier {
    private static final long serialVersionUID = -181894493538251200L;
    private static final String ATTRIBUTE_SKIP_JAVASCRIPT = "skipJavaScript";
    private static final String JS_NAME_PATTERN_FUNCTION = "npFunc";
    private static final String NAME_PATTERN_VERIFIER_FUNCTION = "npvFunc";
    private static final String ATTRIBUTE_SKIP_GLOBAL = "skipGlobal";
    private static final String NAME_ELEMENT_NAME = "name";
    private static final String ELEMENT_RULE_REF = "ruleRef";
    private static final String ELEMENT_SIGN = "sign";
    private static final byte NAME_ID_NAME = 0;
    private static final String NAME_ELEMENT_NAME_PATTERN = "namePattern";
    private static final byte NAME_ID_NAME_PATTERN = 1;
    private static final String NAME_ELEMENT_NAME_PATTERN_REF = "namePatternRef";
    private static final byte NAME_ID_NAME_PATTERN_REF = 2;
    private static final String NAME_ELEMENT_NAME_SIGN = "sign";
    private static final byte NAME_ID_NAME_SIGN = 3;
    private static Map m_elementToNameId = new HashMap();
    private String m_name = null;
    private Pattern m_namePattern = null;
    private Ref m_namePatternRef = null;
    private byte m_nameId = (byte)-1;
    private IVerifier m_verifier = null;
    private boolean m_skipGlobal = false;
    private boolean m_skipJavaScript = false;
    private boolean m_signed = false;

    public static void initialize() {
        m_elementToNameId.put(NAME_ELEMENT_NAME, new Byte(0));
        m_elementToNameId.put(NAME_ELEMENT_NAME_PATTERN, new Byte(1));
        m_elementToNameId.put(NAME_ELEMENT_NAME_PATTERN_REF, new Byte(2));
        m_elementToNameId.put("sign", new Byte(3));
    }

    private Message parameterConstructorFailureMessage() {
        Message m = new Message("parameter constructor failed");
        if (this.m_name != null) {
            m.addDetail(NAME_ELEMENT_NAME, this.m_name);
        }
        return m;
    }

    Parameter(XMLStreamReader sr, String docNamespace, String clientName) throws ParserException, XMLStreamException, ValidatorException {
        try {
            String str = sr.getAttributeValue(null, ATTRIBUTE_SKIP_GLOBAL);
            if (str != null) {
                this.m_skipGlobal = Boolean.valueOf(str);
            }
            if ((str = sr.getAttributeValue(null, ATTRIBUTE_SKIP_JAVASCRIPT)) != null) {
                this.m_skipJavaScript = Boolean.valueOf(str);
            }
            this.readName(sr, docNamespace);
            this.readValidation(sr, docNamespace, clientName);
            StreamReaderHelper.closeElement(sr);
        }
        catch (ValidatorException e) {
            ExceptionHelper.throwValidator((Throwable)e, this.parameterConstructorFailureMessage());
        }
        catch (ParserException e) {
            throw new ParserException(this.parameterConstructorFailureMessage(), (Throwable)e);
        }
        catch (XMLStreamException e) {
            throw new XMLStreamException(this.parameterConstructorFailureMessage().toString(), e);
        }
    }

    private void readName(XMLStreamReader sr, String docNamespace) throws ParserException, XMLStreamException, ValidatorException {
        if (!StreamReaderHelper.moveToNextSibling(sr)) {
            throw new ParserException(new Message("parameter without name"));
        }
        String nameElement = sr.getLocalName();
        Byte b = (Byte)m_elementToNameId.get(nameElement);
        this.m_nameId = b;
        switch (this.m_nameId) {
            case 0: {
                this.m_name = sr.getElementText();
                break;
            }
            case 1: {
                this.m_namePattern = new Pattern(sr);
                break;
            }
            default: {
                this.m_namePatternRef = new Ref(sr, docNamespace);
            }
        }
    }

    private void readValidation(XMLStreamReader sr, String docNamespace, String clientName) throws ParserException, XMLStreamException, ValidatorException {
        if (!StreamReaderHelper.moveToNextSibling(sr)) {
            throw new ParserException(new Message("parameter without a validation instruction"));
        }
        String localName = sr.getLocalName();
        if (localName.equals(ELEMENT_RULE_REF)) {
            this.m_verifier = new Ref(sr, docNamespace);
        } else if (localName.equals("sign")) {
            this.m_verifier = new Sign(sr);
            this.m_signed = true;
        } else {
            this.m_verifier = new Rule(sr, docNamespace, clientName);
        }
    }

    public String name() {
        return this.m_name;
    }

    public boolean usesNamePattern() {
        return this.m_namePattern != null || this.m_namePatternRef != null;
    }

    public boolean skipGlobal() {
        return this.m_skipGlobal;
    }

    public boolean checkForName(String name, IDocAgent docAgent) throws ValidatorException {
        boolean result = false;
        if (name != null) {
            Messages messages = new Messages();
            switch (this.m_nameId) {
                case 0: {
                    if (!name.equals(this.m_name)) break;
                    result = true;
                    break;
                }
                case 1: {
                    if (!this.m_namePattern.verify(name, messages, docAgent, 0, null)) break;
                    result = true;
                    if (!Log.traceEnabled) break;
                    Messages msgs = new Messages(new Message("name pattern match"));
                    msgs.add(this.description());
                    Log.trace(msgs, 10000, "verify");
                    break;
                }
                default: {
                    if (!this.m_namePatternRef.verify(name, messages, docAgent, 0, null)) break;
                    result = true;
                }
            }
        }
        return result;
    }

    public boolean signed() {
        return this.m_signed;
    }

    @Override
    public boolean verify(String value, Messages messages, IDocAgent docAgent, int nestingLevel, StringBuffer modifiedValue) throws ValidatorException {
        boolean valid = true;
        if (!this.m_verifier.verify(value, messages, docAgent, nestingLevel + 1, modifiedValue)) {
            valid = false;
        }
        return valid;
    }

    @Override
    public Messages description() {
        String t = null;
        Messages children = null;
        switch (this.m_nameId) {
            case 0: {
                t = NAME_ELEMENT_NAME;
                break;
            }
            case 1: {
                t = "name pattern";
                children = this.m_namePattern.description();
                break;
            }
            default: {
                t = "name pattern reference";
                children = this.m_namePatternRef.description();
            }
        }
        Message message = new Message("parameter", "name type", t);
        Messages messages = new Messages(message);
        if (children == null) {
            message.addDetail(NAME_ELEMENT_NAME, this.m_name);
        } else {
            messages.addChild(children);
        }
        messages.add(new Message("verifier"));
        messages.addChild(this.m_verifier.description());
        return messages;
    }

    @Override
    public void asJavaScript(JavaScriptDocument jsDoc, List requiredDefinitions, IDocAgent docAgent) throws ValidatorException {
        if (!this.m_skipJavaScript) {
            switch (this.m_nameId) {
                case 0: {
                    jsDoc.startFunction(this.m_name);
                    jsDoc.addLine("var res = CValidator.RES_VALID");
                    this.m_verifier.asJavaScript(jsDoc, requiredDefinitions, docAgent);
                    break;
                }
                default: {
                    int index = docAgent.nextJSParamNameFunctionIndex();
                    jsDoc.startFunction(JS_NAME_PATTERN_FUNCTION + String.valueOf(index));
                    jsDoc.addLine("var res = CValidator.RES_VALID");
                    if (this.m_nameId == 1) {
                        this.m_namePattern.asJavaScript(jsDoc, requiredDefinitions, docAgent);
                    } else {
                        this.m_namePatternRef.asJavaScript(jsDoc, requiredDefinitions, docAgent);
                    }
                    jsDoc.addLine("return res == CValidator.RES_VALID");
                    jsDoc.endFunction();
                    jsDoc.startFunction(NAME_PATTERN_VERIFIER_FUNCTION + String.valueOf(index));
                    jsDoc.addLine("var res = CValidator.RES_VALID");
                    this.m_verifier.asJavaScript(jsDoc, requiredDefinitions, docAgent);
                }
            }
            if (!this.m_skipGlobal) {
                jsDoc.startIf("res == CValidator.RES_VALID");
                jsDoc.addLine("res = this[\"_checkGlobals\"](v)");
                jsDoc.endIf();
            }
            jsDoc.addLine("return res");
            jsDoc.endFunction();
        }
    }

    public String[] sign(String[] values) throws ValidatorException {
        String[] res = null;
        if (this.m_signed) {
            if (values.length != 1) {
                ExceptionHelper.throwValidator(new Message("invalid number of values to sign", "number of values", String.valueOf(values.length)));
            }
            res = new String[]{((Sign)this.m_verifier).sign(values[0])};
        }
        return res;
    }
}

