/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.validator.document;

import com.cognos.validator.api.ValidatorException;
import com.cognos.validator.common.Message;
import com.cognos.validator.common.Messages;
import com.cognos.validator.document.IDocAgent;
import com.cognos.validator.document.IVerifier;
import com.cognos.validator.document.JavaScriptDocument;
import com.cognos.validator.document.ParserException;
import com.cognos.validator.document.StreamReaderHelper;
import com.cognos.validator.util.JavaScript;
import java.io.Serializable;
import java.util.List;
import java.util.regex.Matcher;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class Pattern
implements Serializable,
IVerifier {
    private static final long serialVersionUID = 4093194759856514359L;
    private static final String ATTRIBUTE_CASE_SENSITIVE = "caseSensitive";
    private static final String ATTRIBUTE_MATCH_MODE = "matchMode";
    private static final String MATCH_MODE_FIND = "find";
    private static final String MATCH_MODE_ENTIRE = "entire";
    private static final String ELEMENT_REGEX = "regex";
    private static final String ATTRIBUTE_NOT = "not";
    private boolean m_caseSensitive = true;
    private boolean m_not = false;
    private boolean m_findMode = false;
    private String m_regex = null;
    private java.util.regex.Pattern m_pattern = null;

    public Pattern(XMLStreamReader sr) throws XMLStreamException, ParserException {
        this.readRegex(sr);
        StreamReaderHelper.closeElement(sr);
    }

    private void readAttributes(XMLStreamReader sr) {
        String str = null;
        str = sr.getAttributeValue(null, ATTRIBUTE_CASE_SENSITIVE);
        if (str != null) {
            this.m_caseSensitive = Boolean.valueOf(str);
        }
        if ((str = sr.getAttributeValue(null, ATTRIBUTE_MATCH_MODE)) != null) {
            this.m_findMode = str.equals(MATCH_MODE_FIND);
        }
        if ((str = sr.getAttributeValue(null, ATTRIBUTE_NOT)) != null) {
            this.m_not = Boolean.valueOf(str);
        }
    }

    private void readRegex(XMLStreamReader sr) throws XMLStreamException, ParserException {
        if (!StreamReaderHelper.moveToNextSibling(sr, ELEMENT_REGEX)) {
            throw new ParserException(new Message("pattern without a regex"));
        }
        this.readAttributes(sr);
        this.m_regex = sr.getElementText();
        this.compileRegex(this.m_regex);
    }

    private void compileRegex(String regex) {
        this.m_pattern = java.util.regex.Pattern.compile(regex, this.m_caseSensitive ? 0 : 2);
    }

    @Override
    public boolean verify(String value, Messages messages, IDocAgent docAgent, int nestingLevel, StringBuffer modifiedValue) throws ValidatorException {
        boolean valid = false;
        Matcher m = this.m_pattern.matcher(value);
        valid = this.m_findMode ? m.find() : m.matches();
        if (this.m_not) {
            boolean bl = valid = !valid;
        }
        if (!valid) {
            messages.add(new Message("pattern verify failed"));
            messages.add(this.description());
        }
        return valid;
    }

    @Override
    public Messages description() {
        Message m = new Message("pattern", ELEMENT_REGEX, this.m_regex, "match mode", this.m_findMode ? MATCH_MODE_FIND : MATCH_MODE_ENTIRE);
        if (this.m_not) {
            m.addDetail("logical not operation enabled", "true");
        }
        return new Messages(m);
    }

    @Override
    public void asJavaScript(JavaScriptDocument jsDoc, List requiredDef, IDocAgent docAgent) {
        StringBuffer invocation = new StringBuffer(256);
        invocation.append("res = this[\"_pattern\"](v,");
        invocation.append(this.m_caseSensitive ? "true" : "false");
        invocation.append(",");
        invocation.append(this.m_not ? "true" : "false");
        invocation.append(",");
        invocation.append(this.m_findMode ? "true" : "false");
        invocation.append(",\"");
        invocation.append(JavaScript.jsStrEncode(this.m_regex));
        invocation.append("\")");
        jsDoc.addLine(invocation.toString());
    }
}

