/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.validator.document;

import com.cognos.validator.api.ValidatorException;
import com.cognos.validator.common.ExceptionHelper;
import com.cognos.validator.common.Message;
import com.cognos.validator.common.Messages;
import com.cognos.validator.document.DocumentObject;
import com.cognos.validator.document.IDocAgent;
import com.cognos.validator.document.IVerifier;
import com.cognos.validator.document.JavaScriptDocument;
import com.cognos.validator.document.ParserException;
import com.cognos.validator.document.RefId;
import com.cognos.validator.document.StreamReaderHelper;
import com.cognos.validator.util.JavaScript;
import java.io.Serializable;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class Ref
implements Serializable,
IVerifier {
    private static final long serialVersionUID = 4340802738210065284L;
    private static final String ATTRIBUTE_ID = "id";
    private RefId m_refId = null;
    private transient IVerifier m_verifier = null;

    Ref(XMLStreamReader sr, String docNamespace) throws XMLStreamException, ParserException, ValidatorException {
        String id = sr.getAttributeValue(null, ATTRIBUTE_ID);
        if (id == null) {
            throw new ParserException(new Message("invalid null reference id"));
        }
        this.m_refId = new RefId(id, sr, docNamespace);
        StreamReaderHelper.closeElement(sr);
    }

    private IVerifier verifier(IDocAgent docAgent) throws ValidatorException {
        if (this.m_verifier == null) {
            this.m_verifier = DocumentObject.verifier(this.m_refId, docAgent);
        }
        return this.m_verifier;
    }

    @Override
    public boolean verify(String value, Messages messages, IDocAgent docAgent, int nestingLevel, StringBuffer modifiedValue) throws ValidatorException {
        if (nestingLevel > 64) {
            Messages messages2 = new Messages(new Message("maximum reference nesting reached", "nesting level", String.valueOf(nestingLevel)));
            messages2.addChild(this.m_refId.description());
            ExceptionHelper.throwValidator(messages2);
        }
        return this.verifier(docAgent).verify(value, messages, docAgent, nestingLevel + 1, null);
    }

    @Override
    public Messages description() {
        Messages m = new Messages(new Message("reference"));
        if (this.m_verifier == null) {
            m.addChild(new Message("unresolved verifier"));
        } else {
            m.addChild(this.m_verifier.description());
        }
        return m;
    }

    @Override
    public void asJavaScript(JavaScriptDocument jsDoc, List requiredDef, IDocAgent docAgent) throws ValidatorException {
        jsDoc.add("res = this[\"");
        jsDoc.add(JavaScript.jsStrEncode(this.m_refId.javaScriptId()));
        jsDoc.addLine("\"](v)");
        requiredDef.add(this.verifier(docAgent));
    }
}

