/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.validator.document;

import com.cognos.validator.api.ValidatorException;
import com.cognos.validator.common.Message;
import com.cognos.validator.common.Messages;
import com.cognos.validator.document.ParserException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;

public class RefId
implements Serializable {
    private static final long serialVersionUID = -3212362924335472386L;
    private static final String JAVASCRIPT_ID_PREFIX = "_id_";
    private static final char NAMESPACE_LOCAL_SEPARATOR = ':';
    private String m_namespace = null;
    private String m_localName = null;
    private transient QName m_qName = null;

    RefId(String id, XMLStreamReader sr, String docNamespace) throws ParserException {
        if (id == null) {
            throw new ParserException(new Message("invalid null reference id"));
        }
        int lastDoubleDotIndex = id.lastIndexOf(58);
        if (lastDoubleDotIndex == -1) {
            this.m_localName = id;
        } else {
            String prefix = id.substring(0, lastDoubleDotIndex);
            if (prefix.length() != 0) {
                this.m_namespace = sr.getNamespaceURI(prefix);
            }
            this.m_localName = id.substring(lastDoubleDotIndex + 1);
        }
        if (this.m_namespace == null && docNamespace != null) {
            this.m_namespace = docNamespace;
        }
        this.setQName();
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException, ValidatorException {
        ois.defaultReadObject();
        this.setQName();
    }

    private void setQName() {
        this.m_qName = this.m_namespace == null ? new QName(this.m_localName) : new QName(this.m_namespace, this.m_localName);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.m_namespace != null) {
            sb.append(this.m_namespace);
            sb.append(':');
        }
        sb.append(this.m_localName);
        return sb.toString();
    }

    String namespace() {
        return this.m_namespace;
    }

    String localName() {
        return this.m_localName;
    }

    public int hashCode() {
        return this.m_qName.hashCode();
    }

    public String javaScriptId() {
        StringBuffer res = new StringBuffer(256);
        res.append(JAVASCRIPT_ID_PREFIX);
        if (this.m_namespace != null) {
            res.append(this.m_namespace);
            res.append(':');
        }
        res.append(this.m_localName);
        return res.toString();
    }

    public boolean equals(Object o) {
        boolean res = false;
        if (o instanceof RefId) {
            res = this.m_qName.equals(((RefId)o).m_qName);
        }
        return res;
    }

    public Messages description() {
        return new Messages(new Message("reference id", "namespace", this.m_namespace, "local name", this.m_localName));
    }
}

