/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.validator.document;

import com.cognos.validator.api.ValidatorException;
import com.cognos.validator.common.Log;
import com.cognos.validator.common.Message;
import com.cognos.validator.common.Messages;
import com.cognos.validator.document.Enumeration;
import com.cognos.validator.document.IDocAgent;
import com.cognos.validator.document.IVerifier;
import com.cognos.validator.document.JavaScriptDocument;
import com.cognos.validator.document.ParserException;
import com.cognos.validator.document.Pattern;
import com.cognos.validator.document.Ref;
import com.cognos.validator.document.StreamReaderHelper;
import com.cognos.validator.document.Type;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class Rule
implements Serializable,
IVerifier {
    private static final long serialVersionUID = -2118157104647422164L;
    private static final String ATTRIBUTE_OPERATOR = "operator";
    private static final String OPERATOR_OR = "or";
    private static final String STEP_ELEMENT_ENUMERATION = "enumeration";
    private static final byte STEP_ID_ENUMERATION = 0;
    private static final String STEP_ELEMENT_TYPE = "type";
    private static final byte STEP_ID_TYPE = 1;
    private static final String STEP_ELEMENT_PATTERN = "pattern";
    private static final byte STEP_ID_PATTERN = 2;
    private static final String STEP_ELEMENT_PATTERN_REF = "patternRef";
    private static final byte STEP_ID_PATTERN_REF = 3;
    private static final String STEP_ELEMENT_RULE_REF = "ruleRef";
    private static final byte STEP_ID_RULE_REF = 4;
    private static HashMap m_elementToStepId = new HashMap();
    private boolean m_andOperator = true;
    private List m_verifiers = new LinkedList();

    public static void initialize() {
        m_elementToStepId.put(STEP_ELEMENT_ENUMERATION, new Byte(0));
        m_elementToStepId.put(STEP_ELEMENT_TYPE, new Byte(1));
        m_elementToStepId.put(STEP_ELEMENT_PATTERN, new Byte(2));
        m_elementToStepId.put(STEP_ELEMENT_PATTERN_REF, new Byte(3));
        m_elementToStepId.put(STEP_ELEMENT_RULE_REF, new Byte(4));
    }

    Rule(XMLStreamReader sr, String docNamespace, String clientName) throws XMLStreamException, ParserException, ValidatorException {
        this.readOperatorAttribute(sr);
        this.readRuleSteps(sr, docNamespace, clientName);
    }

    private void readOperatorAttribute(XMLStreamReader sr) {
        String operator = sr.getAttributeValue(null, ATTRIBUTE_OPERATOR);
        if (operator != null && operator.equals(OPERATOR_OR)) {
            this.m_andOperator = false;
        }
    }

    private void readRuleSteps(XMLStreamReader sr, String docNamespace, String clientName) throws XMLStreamException, ParserException, ValidatorException {
        String name = null;
        IVerifier verifier = null;
        while (StreamReaderHelper.moveToNextSibling(sr)) {
            name = sr.getLocalName();
            Byte stepId = (Byte)m_elementToStepId.get(name);
            if (stepId == null) {
                throw new ParserException(new Message("invalid rule step", "name", name));
            }
            if (Log.traceEnabled) {
                Log.trace(new Message("rule parsing", "name", name), 10000, "parser");
            }
            switch (stepId) {
                case 0: {
                    verifier = new Enumeration(sr);
                    break;
                }
                case 1: {
                    verifier = new Type(sr, clientName);
                    break;
                }
                case 2: {
                    verifier = new Pattern(sr);
                    break;
                }
                case 3: 
                case 4: {
                    verifier = new Ref(sr, docNamespace);
                }
            }
            this.m_verifiers.add(verifier);
        }
    }

    @Override
    public boolean verify(String value, Messages messages, IDocAgent docAgent, int nestingLevel, StringBuffer modifiedValue) throws ValidatorException {
        boolean valid = false;
        boolean stepValidStatus = true;
        boolean done = false;
        Iterator i = this.m_verifiers.iterator();
        IVerifier verifier = null;
        while (!done && i.hasNext()) {
            verifier = (IVerifier)i.next();
            stepValidStatus = verifier.verify(value, messages, docAgent, nestingLevel + 1, null);
            if (this.m_andOperator) {
                valid = stepValidStatus;
                if (valid) continue;
                done = true;
                continue;
            }
            if (!stepValidStatus) continue;
            valid = true;
            done = true;
        }
        return valid;
    }

    @Override
    public Messages description() {
        Messages m = new Messages(new Message("rule", ATTRIBUTE_OPERATOR, this.m_andOperator ? "and" : OPERATOR_OR));
        Iterator i = this.m_verifiers.iterator();
        IVerifier verifier = null;
        while (i.hasNext()) {
            verifier = (IVerifier)i.next();
            m.addChild(verifier.description());
        }
        return m;
    }

    @Override
    public void asJavaScript(JavaScriptDocument jsDoc, List requiredDef, IDocAgent docAgent) throws ValidatorException {
        Iterator i = this.m_verifiers.iterator();
        IVerifier verifier = null;
        boolean first = true;
        while (i.hasNext()) {
            verifier = (IVerifier)i.next();
            if (first) {
                verifier.asJavaScript(jsDoc, requiredDef, docAgent);
                first = false;
                continue;
            }
            jsDoc.add("if (res ");
            if (this.m_andOperator) {
                jsDoc.add("==");
            } else {
                jsDoc.add("!=");
            }
            jsDoc.addLine(" 0)", 1);
            verifier.asJavaScript(jsDoc, requiredDef, docAgent);
            jsDoc.endBlock();
        }
    }
}

