/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.validator.document;

import com.cognos.accman.jcam.crypto.CAMFactory;
import com.cognos.accman.jcam.crypto.SigningSession;
import com.cognos.validator.api.ValidatorException;
import com.cognos.validator.common.ExceptionHelper;
import com.cognos.validator.common.Message;
import com.cognos.validator.common.Messages;
import com.cognos.validator.document.IDocAgent;
import com.cognos.validator.document.IVerifier;
import com.cognos.validator.document.JavaScriptDocument;
import com.cognos.validator.document.ParserException;
import com.cognos.validator.document.StreamReaderHelper;
import com.cognos.validator.util.Web64;
import java.io.Serializable;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class Sign
implements Serializable,
IVerifier {
    private static final long serialVersionUID = -9124982277824224129L;
    private static final String ATTRIBUTE_SALT = "salt";
    private static final char SIGN_SEPARATOR = '|';
    private static CAMFactory m_camFactory = null;
    private String m_salt = null;

    public static void initialize(CAMFactory camFactory) throws ValidatorException {
        m_camFactory = camFactory;
    }

    Sign(XMLStreamReader sr) throws XMLStreamException, ParserException {
        this.m_salt = sr.getAttributeValue(null, ATTRIBUTE_SALT);
        StreamReaderHelper.closeElement(sr);
    }

    public String sign(String value) throws ValidatorException {
        if (value == null) {
            ExceptionHelper.throwValidator(new Message("cannot sign null value"));
        }
        String res = null;
        StringBuffer buf = new StringBuffer(value.length() + 256);
        try {
            SigningSession ss = m_camFactory.createSigningSession();
            byte[] byteArrayValue = null;
            if (this.m_salt != null) {
                buf.append(value);
                buf.append(this.m_salt);
                byteArrayValue = buf.toString().getBytes("UTF-8");
            } else {
                byteArrayValue = value.getBytes("UTF-8");
            }
            byte[] hmac = ss.hmac(byteArrayValue);
            byte[] encodedHMAC = Web64.encode(hmac);
            buf.setLength(0);
            buf.append(new String(encodedHMAC, "UTF-8"));
            buf.append('|');
            buf.append(value);
            res = buf.toString();
        }
        catch (Exception e) {
            ExceptionHelper.throwValidator((Throwable)e, new Message("failed to sign"));
        }
        return res;
    }

    @Override
    public boolean verify(String value, Messages messages, IDocAgent docAgent, int nestingLevel, StringBuffer modifiedValue) throws ValidatorException {
        boolean valid = true;
        try {
            int separetorPos = value.indexOf(124);
            if (separetorPos < 1) {
                messages.add(new Message("sign separator not found"));
                valid = false;
            }
            if (valid) {
                String encodedHMAC = value.substring(0, separetorPos);
                String originalValue = value.substring(separetorPos + 1);
                byte[] decodedHMAC = Web64.decode(encodedHMAC.getBytes("UTF-8"));
                SigningSession ss = m_camFactory.createSigningSession();
                String verifyValue = null;
                if (this.m_salt == null) {
                    verifyValue = originalValue;
                } else {
                    StringBuffer buf = new StringBuffer(originalValue.length() + this.m_salt.length());
                    buf.append(originalValue);
                    buf.append(this.m_salt);
                    verifyValue = buf.toString();
                }
                if (!ss.hmacVerify(decodedHMAC, verifyValue.getBytes("UTF-8"))) {
                    valid = false;
                    messages.add(new Message("HMAC verify failed", "verify value", verifyValue, "encoded HMAC", encodedHMAC));
                }
                if (valid) {
                    modifiedValue.append(originalValue);
                }
            }
        }
        catch (Exception e) {
            messages.add(new Message(e.getMessage()));
            valid = false;
        }
        if (!valid) {
            messages.add(new Message("signature verify failed", ATTRIBUTE_SALT, this.m_salt));
        }
        return valid;
    }

    @Override
    public Messages description() {
        Message message = new Message("sign");
        if (this.m_salt != null) {
            message.addDetail(ATTRIBUTE_SALT, this.m_salt);
        }
        return new Messages(message);
    }

    @Override
    public void asJavaScript(JavaScriptDocument jsDoc, List requiredDef, IDocAgent docAgent) {
    }
}

