/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.validator.document;

import com.cognos.validator.common.Message;
import com.cognos.validator.document.ParserException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class StreamReaderHelper {
    public static boolean moveToNextSibling(XMLStreamReader sr) throws XMLStreamException {
        boolean found = false;
        boolean done = false;
        while (!done && sr.hasNext()) {
            sr.nextTag();
            switch (sr.getEventType()) {
                case 1: {
                    found = true;
                    done = true;
                    break;
                }
                case 2: {
                    done = true;
                }
            }
        }
        return found;
    }

    public static boolean moveToNextSibling(XMLStreamReader sr, String name) throws XMLStreamException {
        boolean found = false;
        while (!found && StreamReaderHelper.moveToNextSibling(sr)) {
            QName eleName = sr.getName();
            if (!eleName.getLocalPart().equals(name)) continue;
            found = true;
            break;
        }
        return found;
    }

    public static void closeElement(XMLStreamReader sr) throws XMLStreamException, ParserException {
        boolean found = false;
        while (!found && sr.hasNext()) {
            sr.next();
            switch (sr.getEventType()) {
                case 2: {
                    found = true;
                }
            }
        }
        if (!found) {
            throw new ParserException(new Message("no close tag", "element", sr.getLocalName()));
        }
    }
}

