/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.validator.document;

import com.cognos.validator.api.ValidatorException;
import com.cognos.validator.common.Message;
import com.cognos.validator.common.Messages;
import com.cognos.validator.document.IDocAgent;
import com.cognos.validator.document.IVerifier;
import com.cognos.validator.document.JavaScriptDocument;
import com.cognos.validator.document.ParserException;
import com.cognos.validator.document.StreamReaderHelper;
import com.cognos.validator.document.type.TypeBoolean;
import com.cognos.validator.document.type.TypeDouble;
import com.cognos.validator.document.type.TypeFloat;
import com.cognos.validator.document.type.TypeInt;
import com.cognos.validator.document.type.TypeLong;
import com.cognos.validator.document.type.TypeString;
import com.cognos.validator.document.type.TypeUnsignedInt;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class Type
implements Serializable,
IVerifier {
    private static final long serialVersionUID = -5864124184459194546L;
    private static final byte ID_LONG = 0;
    private static final String NAME_LONG = "long";
    private static final byte ID_STRING = 1;
    private static final String NAME_STRING = "string";
    private static final byte ID_INT = 2;
    private static final String NAME_INT = "int";
    private static final byte ID_UNSIGNED_INT = 3;
    private static final String NAME_UNSIGNED_INT = "unsignedInt";
    private static final byte ID_BOOLEAN = 4;
    private static final String NAME_BOOLEAN = "boolean";
    private static final byte ID_DOUBLE = 5;
    private static final String NAME_DOUBLE = "double";
    private static final byte ID_FLOAT = 6;
    private static final String NAME_FLOAT = "float";
    private static HashMap m_typeNameToId = new HashMap();
    private static HashMap m_IdToTypeName = new HashMap();
    private IVerifier m_verifier = null;

    public static void initialize() {
        m_typeNameToId.put(NAME_LONG, new Byte(0));
        m_typeNameToId.put(NAME_STRING, new Byte(1));
        m_typeNameToId.put(NAME_INT, new Byte(2));
        m_typeNameToId.put(NAME_UNSIGNED_INT, new Byte(3));
        m_typeNameToId.put(NAME_BOOLEAN, new Byte(4));
        m_typeNameToId.put(NAME_DOUBLE, new Byte(5));
        m_typeNameToId.put(NAME_FLOAT, new Byte(6));
        Set set = m_typeNameToId.entrySet();
        Iterator i = set.iterator();
        Map.Entry entry = null;
        while (i.hasNext()) {
            entry = i.next();
            m_IdToTypeName.put(entry.getValue(), entry.getKey());
        }
    }

    Type(XMLStreamReader sr, String clientName) throws ParserException, XMLStreamException, ValidatorException {
        this.readNameElement(sr, clientName);
        StreamReaderHelper.closeElement(sr);
    }

    private void readNameElement(XMLStreamReader sr, String clientName) throws ParserException, XMLStreamException {
        if (!StreamReaderHelper.moveToNextSibling(sr)) {
            throw new ParserException(new Message("type without name element"));
        }
        String name = sr.getLocalName();
        Byte b = (Byte)m_typeNameToId.get(name);
        if (b == null) {
            throw new ParserException(new Message("invalid type", "name", name));
        }
        switch (b) {
            case 4: {
                this.m_verifier = new TypeBoolean(sr);
                break;
            }
            case 2: {
                this.m_verifier = new TypeInt(sr);
                break;
            }
            case 0: {
                this.m_verifier = new TypeLong(sr);
                break;
            }
            case 1: {
                this.m_verifier = new TypeString(sr, clientName);
                break;
            }
            case 3: {
                this.m_verifier = new TypeUnsignedInt(sr);
                break;
            }
            case 5: {
                this.m_verifier = new TypeDouble(sr);
                break;
            }
            case 6: {
                this.m_verifier = new TypeFloat(sr);
            }
        }
    }

    @Override
    public boolean verify(String value, Messages messages, IDocAgent docAgent, int nestingLevel, StringBuffer modifiedValue) throws ValidatorException {
        boolean valid = true;
        if (!this.m_verifier.verify(value, messages, docAgent, nestingLevel + 1, null)) {
            valid = false;
        }
        if (!valid) {
            messages.add(new Message("type verify failed"));
        }
        return valid;
    }

    @Override
    public Messages description() {
        Messages m = new Messages(new Message("type"));
        m.addChild(this.m_verifier.description());
        return m;
    }

    @Override
    public void asJavaScript(JavaScriptDocument jsDoc, List requiredDef, IDocAgent docAgent) throws ValidatorException {
        this.m_verifier.asJavaScript(jsDoc, requiredDef, docAgent);
    }
}

