/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.validator.document.type;

import com.cognos.validator.common.Message;
import com.cognos.validator.document.JavaScriptDocument;
import com.cognos.validator.document.ParserException;
import com.cognos.validator.document.StreamReaderHelper;
import java.io.Serializable;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class Decimal
implements Serializable {
    private static final long serialVersionUID = 130073774258262047L;
    public static final String ATTRIBUTE_MIN = "min";
    public static final String ATTRIBUTE_MAX = "max";
    public static final String ATTRIBUTE_EMPTY_VALID = "emptyValid";
    protected Double m_min = null;
    protected Double m_max = null;
    protected boolean m_emptyValid = false;

    protected Decimal() {
    }

    protected Decimal(XMLStreamReader sr) throws XMLStreamException, ParserException {
        String str = null;
        str = sr.getAttributeValue(null, ATTRIBUTE_MIN);
        if (str != null) {
            this.m_min = new Double(str);
        }
        if ((str = sr.getAttributeValue(null, ATTRIBUTE_MAX)) != null) {
            this.m_max = new Double(str);
        }
        if ((str = sr.getAttributeValue(null, ATTRIBUTE_EMPTY_VALID)) != null && str.equals("true")) {
            this.m_emptyValid = true;
        }
        StreamReaderHelper.closeElement(sr);
    }

    protected boolean checkMinMax(double value, List messages) {
        boolean valid = true;
        if (this.m_min != null && Double.compare(value, this.m_min) < 0) {
            messages.add(new Message("value is smaller than minimum", "minimum", String.valueOf(this.m_min)));
            valid = false;
        } else if (this.m_max != null && Double.compare(value, this.m_max) > 0) {
            messages.add(new Message("value is greater than maximum", "maximum", String.valueOf(this.m_max)));
            valid = false;
        }
        if (!valid) {
            messages.add(new Message("minimum and maximum check failed", "value", String.valueOf(value)));
        }
        return valid;
    }

    protected void description(Message m) {
        if (this.m_min != null) {
            m.addDetail(ATTRIBUTE_MIN, String.valueOf(this.m_min));
        }
        if (this.m_max != null) {
            m.addDetail(ATTRIBUTE_MAX, String.valueOf(this.m_max));
        }
        if (this.m_emptyValid) {
            m.addDetail("empty valid", "true");
        }
    }

    protected void asJavaScript(JavaScriptDocument jsDoc, String type) {
        StringBuffer invocation = new StringBuffer(256);
        invocation.append("res = this[\"_type");
        invocation.append(type);
        invocation.append("\"](v,");
        if (this.m_min == null) {
            invocation.append("null");
        } else {
            invocation.append("'");
            invocation.append(this.m_min);
            invocation.append("'");
        }
        invocation.append(",");
        if (this.m_max == null) {
            invocation.append("null");
        } else {
            invocation.append("'");
            invocation.append(this.m_max);
            invocation.append("'");
        }
        invocation.append(",");
        invocation.append(this.m_emptyValid ? "true" : "false");
        invocation.append(")");
        jsDoc.addLine(invocation.toString());
    }
}

