/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.validator.document.type;

import com.cognos.validator.api.ValidatorException;
import com.cognos.validator.common.Message;
import com.cognos.validator.common.Messages;
import com.cognos.validator.document.IDocAgent;
import com.cognos.validator.document.IVerifier;
import com.cognos.validator.document.JavaScriptDocument;
import com.cognos.validator.document.ParserException;
import com.cognos.validator.document.StreamReaderHelper;
import java.io.Serializable;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class TypeBoolean
implements IVerifier,
Serializable {
    public static final String ATTRIBUTE_EMPTY_VALID = "emptyValid";
    private boolean m_emptyValid = false;
    private static final long serialVersionUID = -2405001682610333017L;

    public TypeBoolean(XMLStreamReader sr) throws XMLStreamException, ParserException {
        String str = null;
        str = sr.getAttributeValue(null, ATTRIBUTE_EMPTY_VALID);
        if (str != null && str.equals("true")) {
            this.m_emptyValid = true;
        }
        StreamReaderHelper.closeElement(sr);
    }

    @Override
    public boolean verify(String value, Messages messages, IDocAgent docAgent, int nestingLevel, StringBuffer modifiedValue) throws ValidatorException {
        boolean valid;
        if (value == null || value.length() == 0) {
            if (this.m_emptyValid) {
                return true;
            }
            messages.add(new Message("empty value not allowed"));
            messages.add(new Message("boolean verify failed"));
            return false;
        }
        boolean bl = valid = value.equals("true") || value.equals("false") || value.equals("0") || value.equals("1");
        if (!valid) {
            messages.add(new Message("value not of type boolean", "valid values", "true, false, 1, and 0"));
            messages.add(new Message("boolean verify failed"));
        }
        return valid;
    }

    @Override
    public Messages description() {
        return new Messages(new Message("boolean"));
    }

    @Override
    public void asJavaScript(JavaScriptDocument jsDoc, List requiredDef, IDocAgent docAgent) {
        jsDoc.addLine("res = this[\"_typeBoolean\"](v)");
    }
}

