/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.validator.document.type;

import com.cognos.validator.api.ValidatorException;
import com.cognos.validator.common.Message;
import com.cognos.validator.common.Messages;
import com.cognos.validator.document.IDocAgent;
import com.cognos.validator.document.IVerifier;
import com.cognos.validator.document.JavaScriptDocument;
import com.cognos.validator.document.ParserException;
import com.cognos.validator.document.type.Numeric;
import java.io.Serializable;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class TypeLong
extends Numeric
implements IVerifier,
Serializable {
    private static final long serialVersionUID = 4329411319923270862L;

    public TypeLong(XMLStreamReader sr) throws XMLStreamException, ParserException {
        super(sr);
    }

    @Override
    public boolean verify(String value, Messages messages, IDocAgent docAgent, int nestingLevel, StringBuffer modifiedValue) throws ValidatorException {
        boolean valid = true;
        if (value.length() > 0 || !this.m_emptyValid) {
            long l = -1L;
            try {
                l = Long.parseLong(value);
            }
            catch (NumberFormatException e) {
                messages.add(new Message("value not a long"));
                valid = false;
            }
            if (valid && !this.checkMinMax(l, messages)) {
                valid = false;
            }
            if (!valid) {
                messages.add(new Message("long verify failed"));
            }
        }
        return valid;
    }

    @Override
    public Messages description() {
        Message m = new Message("long");
        super.description(m);
        return new Messages(m);
    }

    @Override
    public void asJavaScript(JavaScriptDocument jsDoc, List requiredDef, IDocAgent docAgent) {
        super.asJavaScript(jsDoc, "Long");
    }
}

