/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.validator.document.type;

import com.cognos.validator.api.ValidatorException;
import com.cognos.validator.common.Message;
import com.cognos.validator.common.Messages;
import com.cognos.validator.document.IDocAgent;
import com.cognos.validator.document.IVerifier;
import com.cognos.validator.document.JavaScriptDocument;
import com.cognos.validator.document.ParserException;
import com.cognos.validator.document.StreamReaderHelper;
import com.cognos.validator.util.FromCAF;
import java.io.Serializable;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class TypeString
implements IVerifier,
Serializable {
    private static final long serialVersionUID = 9048061399119494718L;
    public static final String ATTRIBUTE_MIN_LENGTH = "minLength";
    public static final String ATTRIBUTE_MAX_LENGTH = "maxLength";
    public static final String ATTRIBUTE_URL_TYPE = "urlType";
    private Long m_minLength = null;
    private Long m_maxLength = null;
    private boolean m_urlType = false;
    private String m_clientName = "";

    public TypeString(XMLStreamReader sr, String clientName) throws XMLStreamException, ParserException {
        this.readMinMaxLengthAttributes(sr);
        StreamReaderHelper.closeElement(sr);
        this.m_clientName = clientName;
    }

    private void readMinMaxLengthAttributes(XMLStreamReader sr) {
        String str = null;
        str = sr.getAttributeValue(null, ATTRIBUTE_MIN_LENGTH);
        if (str != null) {
            this.m_minLength = new Long(str);
        }
        if ((str = sr.getAttributeValue(null, ATTRIBUTE_MAX_LENGTH)) != null) {
            this.m_maxLength = new Long(str);
        }
        if ((str = sr.getAttributeValue(null, ATTRIBUTE_URL_TYPE)) != null && str.equals("true")) {
            this.m_urlType = true;
        }
    }

    @Override
    public boolean verify(String value, Messages messages, IDocAgent docAgent, int nestingLevel, StringBuffer modifiedValue) throws ValidatorException {
        boolean valid = true;
        if (this.m_minLength != null && (long)value.length() < this.m_minLength) {
            messages.add(new Message("value length is smaller than minimum", "minimum", this.m_minLength.toString()));
            valid = false;
        } else if (this.m_maxLength != null && (long)value.length() > this.m_maxLength) {
            messages.add(new Message("value length is greater than maximum", "maximum", this.m_maxLength.toString()));
            valid = false;
        }
        if (!valid) {
            messages.add(new Message("length check failed", "value length", String.valueOf(value.length())));
            messages.add(new Message("string verify failed"));
        }
        if (valid && this.m_urlType) {
            valid = FromCAF.postCheck(this.m_clientName, value, messages);
        }
        return valid;
    }

    @Override
    public Messages description() {
        Message m = new Message("string");
        if (this.m_minLength != null) {
            m.addDetail("min length", String.valueOf(this.m_minLength));
        }
        if (this.m_maxLength != null) {
            m.addDetail("max length", String.valueOf(this.m_maxLength));
        }
        return new Messages(m);
    }

    @Override
    public void asJavaScript(JavaScriptDocument jsDoc, List requiredDef, IDocAgent docAgent) {
        StringBuffer invocation = new StringBuffer(256);
        invocation.append("res = this[\"_typeString\"](v,");
        if (this.m_minLength == null) {
            invocation.append("null");
        } else {
            invocation.append(this.m_minLength);
        }
        invocation.append(",");
        if (this.m_maxLength == null) {
            invocation.append("null");
        } else {
            invocation.append(this.m_maxLength);
        }
        invocation.append(",");
        if (!this.m_urlType) {
            invocation.append("false");
        } else {
            invocation.append("true");
        }
        invocation.append(")");
        jsDoc.addLine(invocation.toString());
    }
}

