/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.validator.util;

import com.cognos.validator.common.Message;
import com.cognos.validator.common.Messages;
import com.cognos.validator.util.ValidatorConfig;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FromCAF {
    private static Pattern m_urlPattern = Pattern.compile("^(#.+|[\\w._-]+|(\\.|\\.\\.|\\/|[\\w_-]+)?((\\/([\\w.?_!~*'();<>:@+$,#=&%-]+))+))$|^http(s)?://([\\w-]+)([\\w.-]+)([\\w-]+)(:(\\d|[1-9]\\d|[1-9]\\d\\d|[1-9]\\d\\d\\d|[1-5]\\d\\d\\d\\d|6[0-4]\\d\\d\\d|65[0-4]\\d\\d|655[0-2]\\d|6553[0-5]))?((/?)|((/.+)+/?))$");
    private static Pattern m_allowedJavaScript = Pattern.compile("(?i)(about:blank|(javascript:window.close()|javascript:parent.close()|javascript:history.back()|parent.cancelerrorpage()|docancel())(;)?)");
    private static Pattern m_categoryJS = Pattern.compile("^(about:blank|getURL\\(\"pid=index\"\\)|(?i)javascript:.+)$");
    private static Pattern m_JSexceptions = Pattern.compile("^(about:blank|getURL\\(\"pid=index\"\\)|(?i)javascript:(((parent|window)\\.)?close|doCancel|history\\.back|parent\\.cancelErrorPage|parent\\.ui_modal_dialog\\.close|parent\\.[-\\da-z_A-Z]{1,1024}callBack)(\\(\\)|\\(true\\));?)$");
    private static Pattern m_categoryAbsURL = Pattern.compile("^[^:]{1,32}:.+$");
    private static Pattern m_absURL = Pattern.compile("(?i)^(http(s)?://((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]\\d|\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]\\d|\\d)){3}|(\\[(::[\\dA-Fa-f]{1,4}(:[\\dA-Fa-f]{1,4}){0,3}((:[\\dA-Fa-f]{1,4}){0,2}|:(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]\\d|\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]\\d|\\d)){3})|[\\dA-Fa-f]{1,4}(::[\\dA-Fa-f]{1,4}(:[\\dA-Fa-f]{1,4}){0,2}|:[\\dA-Fa-f]{1,4}::[\\dA-Fa-f]{1,4}(:[\\dA-Fa-f]{1,4}){0,1}|(:[\\dA-Fa-f]{1,4}){2}::[\\dA-Fa-f]{1,4})((:[\\dA-Fa-f]{1,4}){0,2}|:(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]\\d|\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]\\d|\\d)){3})|[\\dA-Fa-f]{1,4}(:[\\dA-Fa-f]{1,4}){0,3}::(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]\\d|\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]\\d|\\d)){3}|[\\dA-Fa-f]{1,4}(:[\\dA-Fa-f]{1,4}){3}(::[\\dA-Fa-f]{1,4}(:[\\dA-Fa-f]{1,4}){0,1}|:[\\dA-Fa-f]{1,4}::[\\dA-Fa-f]{1,4})|[\\dA-Fa-f]{1,4}(:[\\dA-Fa-f]{1,4}){5}((:[\\dA-Fa-f]{1,4}){0,2}|:(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]\\d|\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]\\d|\\d)){3}))\\])|([\\w.-]+)([\\w.-]+)([\\w-]+))(:(\\d|[1-9]\\d|[1-9]\\d\\d|[1-9]\\d\\d\\d|[1-5]\\d\\d\\d\\d|6[0-4]\\d\\d\\d|65[0-4]\\d\\d|655[0-2]\\d|6553[0-5]))?((/?)|((/.+)+/?)))$");
    private static Pattern m_backSlashedAbsURL = Pattern.compile("^http(s)?:\\\\\\\\.+$");
    private static Pattern m_relativeURL = Pattern.compile("(?!^/\\s+/)^(/|./|../|#.+|[^.]([^:]+\\/?))(([^\\/]+|([^\\/]+\\/)+[^\\/]+))$");
    private static Pattern m_categorySlashSlashURL = Pattern.compile("^//+");

    public static boolean checkURLHostDomain(String inputURL, Messages messages) {
        return FromCAF.checkURLHostDomain("ibm.cognos.global", inputURL, messages);
    }

    public static boolean checkURLHostDomain(String clientName, String inputURL, Messages messages) {
        boolean res = false;
        boolean done = false;
        String strURL = inputURL.toLowerCase();
        try {
            ValidatorConfig.initialize();
            URL url = null;
            if (strURL.length() == 0 || strURL.charAt(0) == '/' || strURL.charAt(0) == '?') {
                res = true;
                done = true;
            }
            Matcher m = m_allowedJavaScript.matcher(strURL);
            if (!done && m.find()) {
                res = true;
                done = true;
            }
            Matcher validURL = m_urlPattern.matcher(strURL);
            if (!done && !validURL.find()) {
                res = false;
                done = true;
                messages.add(new Message(strURL + " fails URL regex."));
            }
            if (!done) {
                try {
                    url = new URL(strURL);
                }
                catch (MalformedURLException e) {
                    done = true;
                    messages.add(new Message("malformed URL:" + e.getMessage()));
                }
                if (!url.getProtocol().equals("http") && !url.getProtocol().equals("https")) {
                    done = true;
                    res = false;
                    messages.add(new Message("URL protocol unkown."));
                }
            }
            if (!done) {
                StringBuffer hostPort;
                String host = url.getHost();
                int dotPos = host.indexOf(46);
                String hostString = "";
                if (dotPos > 0 && ValidatorConfig.validDomainsManager.isValid(clientName, hostString = host.substring(dotPos))) {
                    res = true;
                }
                int port = url.getPort();
                if (!res) {
                    if (port == -1 && ValidatorConfig.m_validHostPorts.contains(host)) {
                        res = true;
                    } else {
                        hostPort = new StringBuffer(host);
                        if (port != -1) {
                            hostPort.append(':');
                            hostPort.append(port);
                        } else if (url.getProtocol().equals("http")) {
                            hostPort.append(":80");
                        } else if (url.getProtocol().equals("https")) {
                            hostPort.append(":443");
                        } else {
                            done = true;
                            messages.add(new Message("URL with unkown protocol without port specified."));
                            messages.add(new Message("protocol:" + url.getProtocol()));
                            messages.add(new Message("host;" + hostPort.toString()));
                        }
                        if (ValidatorConfig.m_validHostPorts.contains(hostPort.toString())) {
                            res = true;
                        } else if ((port == 80 && url.getProtocol().equals("http") || port == 443 && url.getProtocol().equals("https")) && ValidatorConfig.m_validHostPorts.contains(host)) {
                            res = true;
                        }
                    }
                }
                if (!done && !res) {
                    hostPort = new StringBuffer(host);
                    if (port != -1) {
                        hostPort.append(':');
                        hostPort.append(port);
                    }
                    messages.add(new Message("Invalid URL domain or host."));
                    messages.add(new Message("host port:" + hostPort.toString()));
                    messages.add(new Message("URL does not match any valid domain or host."));
                    messages.add(new Message("valid hosts:" + ValidatorConfig.m_validHostPorts.toString()));
                    messages.add(new Message("valid domains:" + ValidatorConfig.validDomainsManager.toString()));
                    messages.add(new Message("client name:" + clientName));
                    messages.add(new Message("input URL:" + inputURL));
                    messages.add(new Message("hostString for ValidDomainManager:" + hostString));
                }
            }
            if (!res) {
                // empty if block
            }
            return res;
        }
        catch (Exception e) {
            messages.add(new Message("URL validation exception failure."));
            res = false;
            return res;
        }
    }

    public static boolean postCheck(String value, Messages messages) {
        return FromCAF.postCheck("ibm.cognos.global", value, messages);
    }

    public static boolean postCheck(String clientName, String value, Messages messages) {
        boolean res = false;
        if (value.length() == 0) {
            res = true;
            return res;
        }
        StringBuffer htmlUnescapeVal = new StringBuffer();
        boolean decoded = FromCAF.htmlDecode(value.toCharArray(), htmlUnescapeVal);
        String checkValueString = value;
        if (decoded) {
            checkValueString = htmlUnescapeVal.toString();
        }
        if (FromCAF.checkPattern(m_categoryJS, checkValueString)) {
            res = FromCAF.checkPattern(m_JSexceptions, checkValueString);
        } else if (FromCAF.checkPattern(m_categoryAbsURL, value)) {
            if (FromCAF.checkPattern(m_backSlashedAbsURL, value)) {
                value = value.replaceFirst("\\\\\\\\", "//");
            }
            res = FromCAF.checkAbsURLAndHostDomain(clientName, value, messages);
        } else if (FromCAF.checkPattern(m_categorySlashSlashURL, value)) {
            value = "http:" + value;
            res = FromCAF.checkAbsURLAndHostDomain(clientName, value, messages);
        } else if (FromCAF.checkPattern(m_relativeURL, value)) {
            res = true;
        } else {
            messages.add(new Message("postCheck did not find a category."));
            messages.add(new Message(value + " does not match allowed URL patterns."));
        }
        return res;
    }

    private static boolean checkAbsURLAndHostDomain(String clientName, String value, Messages messages) {
        boolean res = FromCAF.checkPattern(m_absURL, value);
        if (res) {
            res = FromCAF.checkURLHostDomain(clientName, value, messages);
        }
        return res;
    }

    private static boolean checkPattern(Pattern pattern, String value) {
        return pattern.matcher(value).lookingAt();
    }

    private static boolean htmlDecode(char[] urlData, StringBuffer outBuf) {
        boolean decode = false;
        boolean res = false;
        int num = -1;
        int h1 = 0;
        int h2 = 0;
        char c0 = '\u0000';
        char c1 = '\u0000';
        char c2 = '\u0000';
        int c3 = 0;
        int c4 = 0;
        char c5 = '\u0000';
        int udLen = urlData.length;
        int pos = -1;
        pos = FromCAF.indexOf(urlData, '&');
        if (pos != -1) {
            outBuf.ensureCapacity(urlData.length * 2);
            if (pos > 0) {
                outBuf.append(urlData, 0, pos);
            }
        }
        if (pos != -1) {
            int tempbuflen = (udLen - pos + 1) * 2;
            char[] tempbuf = new char[tempbuflen];
            int tempbufidx = -1;
            for (int i = pos; i < udLen; ++i) {
                decode = false;
                c0 = urlData[i];
                if (c0 == '&' && i + 3 < udLen) {
                    c1 = urlData[i + 1];
                    c2 = urlData[i + 2];
                    c3 = urlData[i + 3];
                    if (i + 4 < udLen) {
                        c4 = urlData[i + 4];
                        if (i + 5 < udLen) {
                            c5 = urlData[i + 5];
                        }
                    }
                    if (c3 == 59) {
                        if (c1 == 'l' && c2 == 't' || c1 == 'L' && c2 == 'T') {
                            tempbuf[++tempbufidx] = 60;
                            decode = true;
                            i += 3;
                        } else if (c1 == 'g' && c2 == 't' || c1 == 'G' && c2 == 'T') {
                            tempbuf[++tempbufidx] = 62;
                            decode = true;
                            i += 3;
                        }
                    } else if (i + 4 < udLen && (c1 == 'a' && c2 == 'm' && c3 == 112 || c1 == 'A' && c2 == 'M' && c2 == 'P') && c4 == 59) {
                        tempbuf[++tempbufidx] = 38;
                        decode = true;
                        i += 4;
                    } else if (c1 == '#') {
                        if (c2 >= '0' && c2 <= '9') {
                            if (c3 == 59) {
                                tempbuf[++tempbufidx] = (char)(c2 - 48);
                                decode = true;
                                i += 3;
                            } else if (i + 4 < udLen && c3 >= 48 && c3 <= 57 && c4 == 59) {
                                tempbuf[++tempbufidx] = (char)((c2 - 48) * 10 + c3 - 48);
                                decode = true;
                                i += 4;
                            } else if (i + 5 < udLen && c3 >= 48 && c3 <= 57 && c4 >= 0 && c4 <= 57 && c5 == ';' && (num = (c2 - 48) * 100 + (c3 - 48) * 10 + c4 - 48) < 256) {
                                tempbuf[++tempbufidx] = (char)num;
                                decode = true;
                                i += 5;
                            }
                        } else if (c2 == 'x' && i + 4 < udLen && FromCAF.isHexDigit(c3)) {
                            h1 = 0;
                            h2 = 0;
                            if (c4 == 59) {
                                h2 = c3;
                                decode = true;
                                i += 4;
                            } else if (i + 5 < udLen && FromCAF.isHexDigit(c4) && c5 == ';') {
                                h1 = c3;
                                h2 = c4;
                                decode = true;
                                i += 5;
                            }
                            if (decode) {
                                if (h1 != 0) {
                                    h1 = h1 >= 48 && h1 <= 57 ? (int)((char)(h1 - 48)) : (h1 >= 97 && h1 <= 102 ? (int)((char)(10 + h1 - 97)) : (int)((char)(10 + h1 - 65)));
                                }
                                h2 = h2 >= 48 && h2 <= 57 ? (int)((char)(h2 - 48)) : (h2 >= 97 && h2 <= 102 ? (int)((char)(10 + h2 - 97)) : (int)((char)(10 + h2 - 65)));
                                tempbuf[++tempbufidx] = (char)((h1 << 4) + h2);
                            }
                        }
                    } else if (i + 5 < udLen && (c1 == 'q' && c2 == 'u' && c3 == 111 && c4 == 116 && c5 == ';' || c1 == 'Q' && c2 == 'U' && c3 == 79 && c4 == 84 && c5 == ';')) {
                        tempbuf[++tempbufidx] = 34;
                        decode = true;
                        i += 5;
                    }
                }
                if (decode) {
                    if (res) continue;
                    res = true;
                    continue;
                }
                tempbuf[++tempbufidx] = c0;
            }
            if (tempbufidx >= 0) {
                outBuf.append(tempbuf, 0, tempbufidx + 1);
            }
        }
        if (!res) {
            outBuf.setLength(0);
        }
        return res;
    }

    private static int indexOf(char[] str, char c) {
        int strlen = str.length;
        for (int i = 0; i < strlen; ++i) {
            if (str[i] != c) continue;
            return i;
        }
        return -1;
    }

    private static boolean isHexDigit(int ch) {
        return ch >= 97 && ch <= 102 || ch >= 48 && ch <= 57 || ch >= 65 && ch <= 90;
    }
}

