/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.validator.util;

public class JavaScript {
    public static final int NO_BLOCK = 0;
    public static final int START_BLOCK = 1;
    public static final int END_BLOCK = 2;
    public static final String NULL = "null";
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    private static final int INDENT_SIZE = 2;
    private StringBuffer m_buf = new StringBuffer();
    private int m_indent = 0;
    private boolean m_lineInProgress = false;

    public static String jsStrEncode(String str) {
        String res = str.replaceAll("\\\\", "\\\\\\\\");
        res = res.replaceAll("\\'", "\\\\'");
        res = res.replaceAll("\\\"", "\\\\\"");
        return res;
    }

    protected void reset() {
        this.m_buf.setLength(0);
        this.m_indent = 0;
        this.m_lineInProgress = false;
    }

    private void addIndent() {
        int indentSize = this.m_indent * 2;
        for (int i = 0; i < indentSize; ++i) {
            this.m_buf.append(' ');
        }
    }

    public void endBlock() {
        --this.m_indent;
        this.m_lineInProgress = false;
        this.addLine("}", 0, false);
    }

    private void _handleBlock(int block, boolean semicolon) {
        if (block == 1) {
            this.m_buf.append(" {\n");
            ++this.m_indent;
            this.m_lineInProgress = false;
        } else if (block == 2) {
            this.m_buf.append(semicolon ? ";\n" : "\n");
            this.endBlock();
        }
    }

    public void addCase(String statement) {
        this.add("case \"");
        this.add(JavaScript.jsStrEncode(statement));
        this.addLine("\": \n", 0, false);
        this.m_lineInProgress = false;
    }

    public void add(String str) {
        this.add(str, 0);
    }

    public void add(String str, int block) {
        if (!this.m_lineInProgress) {
            this.addIndent();
            this.m_lineInProgress = true;
        }
        this.m_buf.append(str);
        if (block != 0) {
            this._handleBlock(block, block == 2 && str.length() > 0);
        }
    }

    public void addLine(String str) {
        this.addLine(str, 0);
    }

    public void addLine(String str, int block) {
        this.addLine(str, block, str.length() > 0);
    }

    protected void addLine(String str, int block, boolean semicolon) {
        if (!this.m_lineInProgress) {
            this.addIndent();
        }
        this.m_buf.append(str);
        if (block == 0) {
            this.m_buf.append(semicolon && str.length() > 0 ? ";\n" : "\n");
        } else {
            this._handleBlock(block, semicolon);
        }
        this.m_lineInProgress = false;
    }

    public void indent() {
        ++this.m_indent;
    }

    public void unindent() {
        if (this.m_indent > 0) {
            --this.m_indent;
        }
    }

    public String toString() {
        return this.m_buf.toString();
    }

    public void startIf(String condition) {
        this.add("if (");
        this.add(condition);
        this.add(")", 1);
    }

    public void addElse() {
        this.unindent();
        this.addLine("} else", 1);
    }

    public void endIf() {
        this.endBlock();
    }

    public void addComment(String comment) {
        this.add("// ");
        this.addLine(comment, 0, false);
    }
}

