/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.validator.util;

import com.cognos.validator.api.ValidatorException;
import com.cognos.validator.common.ExceptionHelper;
import com.cognos.validator.common.Message;
import com.cognos.validator.common.Messages;
import com.cognos.validator.util.Stream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class SchemaValidator {
    public static final String XSD_RESOURCE = "com/cognos/validator/schema/validator.xsd";
    private ErrorChecker m_errorChecker;
    private XMLReader m_xmlReader;
    private static IResourceResolver m_resourceResolver = null;

    public static void registerResourceResolver(IResourceResolver rr) {
        if (rr != null) {
            m_resourceResolver = rr;
        }
    }

    private static byte[] getSchemaAsByteArray() throws ValidatorException {
        byte[] res = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ClassLoader cl = SchemaValidator.class.getClassLoader();
        InputStream is = cl.getResourceAsStream(XSD_RESOURCE);
        if (is == null) {
            if (m_resourceResolver != null) {
                is = m_resourceResolver.getResourceAsStream(XSD_RESOURCE);
            }
            if (is == null) {
                ExceptionHelper.throwValidator(new Message("XSD inputstream is null"));
            }
        }
        Stream.readInputStream(is, baos);
        res = baos.toByteArray();
        return res;
    }

    public static void initialize() throws ValidatorException {
        InlineSpecEntityResolver.initialize(SchemaValidator.getSchemaAsByteArray());
    }

    public SchemaValidator() throws ValidatorException {
        try {
            SAXParserFactory saxFactory = SAXParserFactory.newInstance();
            saxFactory.setNamespaceAware(true);
            saxFactory.setValidating(true);
            saxFactory.setFeature("http://apache.org/xml/features/validation/schema", true);
            SAXParser saxParser = saxFactory.newSAXParser();
            this.m_xmlReader = saxParser.getXMLReader();
            this.m_errorChecker = new ErrorChecker();
            this.m_xmlReader.setErrorHandler(this.m_errorChecker);
            this.m_xmlReader.setEntityResolver(new InlineSpecEntityResolver());
            this.m_xmlReader.setFeature("http://apache.org/xml/features/validation/schema-full-checking", true);
            this.m_xmlReader.setProperty("http://apache.org/xml/properties/schema/external-schemaLocation", "http://developer.cognos.com/schemas/validator/1/ validator.xsd");
        }
        catch (Exception e) {
            ExceptionHelper.throwValidator(e);
        }
    }

    public void validate(Reader reader) throws ValidatorException {
        try {
            InputSource is = new InputSource(reader);
            this.m_xmlReader.parse(is);
        }
        catch (Exception e) {
            ExceptionHelper.throwValidator(e);
        }
        if (this.m_errorChecker.errorOccured()) {
            ExceptionHelper.throwValidator(this.m_errorChecker.m_messages);
        }
    }

    private class ErrorChecker
    extends DefaultHandler {
        public Messages m_messages = new Messages();
        private int m_errorCount = 0;

        private ErrorChecker() {
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            if (this.m_errorCount == 0) {
                this.m_messages.add(new Message("schema validation failed"));
            }
            ++this.m_errorCount;
            Messages messages = new Messages();
            messages.add(new Message("failure on line " + e.getLineNumber()));
            messages.add(new Message(e.getMessage()));
            this.m_messages.addChild(messages);
        }

        public boolean errorOccured() {
            return this.m_errorCount > 0;
        }
    }

    public static interface IResourceResolver {
        public InputStream getResourceAsStream(String var1);
    }

    private static class InlineSpecEntityResolver
    implements EntityResolver {
        private static byte[] m_schema = null;

        static void initialize(byte[] schema) {
            m_schema = schema;
        }

        @Override
        public InputSource resolveEntity(String arg0, String arg1) throws SAXException, IOException {
            return new InputSource(new ByteArrayInputStream(m_schema));
        }
    }
}

