/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.validator.util;

import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.validator.common.ValidDomainManager;
import com.cognos.validator.common.ValidatorExceptionImpl;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class ValidatorConfig {
    static final String CAF_TRUE = "true";
    private static Element m_topCCL = null;
    public static HashSet m_validHostPorts = new HashSet();
    public static ValidDomainManager validDomainsManager = new ValidDomainManager();
    private static ICCLConfiguration m_cclConfig = null;

    public static void initialize() throws Exception {
        if (m_cclConfig == null) {
            try {
                m_cclConfig = CCLConfigurationFactory.getInstance();
                m_cclConfig.init();
                ValidatorConfig.cclConfigure();
                ValidatorConfig.configureURLDomainHost(m_cclConfig);
            }
            catch (Exception e) {
                m_cclConfig = null;
                throw new ValidatorExceptionImpl("Failed initializing CCLConfiguration.", e);
            }
        }
    }

    public static boolean addClientDomain(String clientName, String value) {
        return validDomainsManager.addDomain(clientName, value);
    }

    public static void resetDomains(String clientName) {
        validDomainsManager.resetDomains(clientName);
    }

    private static void configureURLDomainHost(ICCLConfiguration cclConfig) throws ValidatorExceptionImpl {
        String hostPort = ValidatorConfig.fetchCCLGatewayValue(cclConfig);
        ValidatorConfig.addValidHostDomain(hostPort);
    }

    public static String fetchCCLGatewayValue(ICCLConfiguration cclConfig) throws ValidatorExceptionImpl {
        String gateway = null;
        try {
            gateway = cclConfig.getValue("gateway", false);
        }
        catch (Exception e) {
            throw new ValidatorExceptionImpl("GATEWAY_READ_FAILED", e);
        }
        if (gateway.length() > 0) {
            URL url = null;
            try {
                gateway = gateway.toLowerCase();
                if (gateway.startsWith("https")) {
                    gateway = "http" + gateway.substring("https".length());
                }
                url = new URL(gateway.toLowerCase());
            }
            catch (Exception e) {
                throw new ValidatorExceptionImpl("ERROR_READING_GATEWAY", e);
            }
            String host = url.getHost();
            StringBuffer hostPort = new StringBuffer(host);
            if (url.getPort() > 0) {
                hostPort.append(':');
                hostPort.append(url.getPort());
            }
            gateway = hostPort.toString();
        }
        return gateway;
    }

    private static void cclConfigure() throws ValidatorExceptionImpl {
        try {
            String sSection = "CAF";
            m_topCCL = m_cclConfig.getValueElement(sSection, false);
            if (m_topCCL == null) {
                throw new ValidatorExceptionImpl("NO_TOP_CCL_ELEMENT");
            }
            String CRN_PARAMETER_TAG = "parameter";
            Namespace nsCRN = new Namespace("crn", "http://developer.cognos.com/schemas/crconfig/1/");
            QName qnParameter = new QName(CRN_PARAMETER_TAG, nsCRN);
            List parameterElementList = m_topCCL.elements(qnParameter);
            int length = parameterElementList.size();
            for (int loop = 0; loop < length; ++loop) {
                Element parameterNode = (Element)parameterElementList.get(loop);
                Attribute nameAttr = (Attribute)parameterNode.selectSingleNode("@name");
                if (!nameAttr.getValue().equals("caf_validDomainList")) continue;
                List itemNodes = parameterNode.selectNodes("./crn:value/crn:item");
                for (Element item : itemNodes) {
                    ValidatorConfig.addValidHostDomain(item.getText());
                }
            }
        }
        catch (Exception e) {
            throw new ValidatorExceptionImpl("CCL_CONFIGURE_FAILED", e);
        }
    }

    private static boolean checkMalformedURL(String hostDomainValue) {
        try {
            new URL("http://" + hostDomainValue.toLowerCase());
        }
        catch (MalformedURLException e) {
            return false;
        }
        return true;
    }

    private static void addValidHostDomain(String hostDomainValue) throws ValidatorExceptionImpl {
        block16: {
            try {
                hostDomainValue = hostDomainValue.trim().toLowerCase();
                if (hostDomainValue.length() <= 0 || validDomainsManager.addDomain(hostDomainValue)) break block16;
                String localHostName = null;
                String FQHostName = null;
                if (ValidatorConfig.checkMalformedURL(hostDomainValue)) {
                    m_validHostPorts.add(hostDomainValue);
                }
                try {
                    InetAddress localMachine = InetAddress.getLocalHost();
                    FQHostName = localMachine.getCanonicalHostName().toLowerCase();
                    localHostName = localMachine.getHostName();
                }
                catch (UnknownHostException uhe) {
                    throw new ValidatorExceptionImpl("Malformed URL", uhe);
                }
                try {
                    if (localHostName != null && localHostName.length() > 0) {
                        URL urlHostDomain = new URL("http://" + hostDomainValue.toLowerCase());
                        String host = urlHostDomain.getHost();
                        int port = urlHostDomain.getPort();
                        if ("localhost".equals(host)) {
                            if (port != -1) {
                                localHostName = localHostName + ":" + String.valueOf(port);
                            }
                            m_validHostPorts.add(localHostName.toLowerCase());
                        } else if (localHostName.equals(host)) {
                            String localHost = "localhost";
                            if (port != -1) {
                                localHost = localHost + ":" + String.valueOf(port);
                            }
                            m_validHostPorts.add(localHost);
                        } else if (FQHostName.equals(host)) {
                            String localHost = "localhost";
                            if (port != -1) {
                                localHost = localHost + ":" + String.valueOf(port);
                            }
                            m_validHostPorts.add(localHost);
                        }
                    }
                }
                catch (MalformedURLException mue) {
                    throw new ValidatorExceptionImpl("Malformed URL", mue);
                }
            }
            catch (Exception e) {
                throw new ValidatorExceptionImpl("Add Valid Host Domain List failed", e);
            }
        }
    }
}

