/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.rare.vcv5lib;

import com.ibm.aurora.rare.IClassificationStreamer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class VCV5ClassificationStreamer
implements IClassificationStreamer {
    private static final String _sTemplatesRoot = "templates/";
    private final String _sRootPath;
    private final String _sClassificationRoot;

    public VCV5ClassificationStreamer(String rootPath, String classificationRoot) {
        this._sRootPath = rootPath;
        this._sClassificationRoot = classificationRoot;
    }

    protected String getRootPath() {
        return this._sRootPath;
    }

    public InputStream getClassificationStream() throws IOException {
        File classificationFile = new File(this.getRootPath() + this._sClassificationRoot);
        if (classificationFile.exists()) {
            return new FileInputStream(classificationFile);
        }
        return this.getClass().getResourceAsStream("/classification/" + this._sClassificationRoot);
    }

    public InputStream getTemplateStream(String name) throws IOException {
        File templateFile = new File(this.getRootPath() + _sTemplatesRoot + name + ".xml");
        if (templateFile.exists()) {
            return new FileInputStream(templateFile);
        }
        return this.getClass().getResourceAsStream("/classification/templates/" + name + ".xml");
    }
}

