/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.rare.vcv5lib;

import com.ibm.aurora.rare.IIndividualParameterFactory;
import com.ibm.aurora.rare.IRARELibrary;
import com.ibm.aurora.rare.core.exception.ParameterCreationException;
import com.ibm.aurora.rare.core.parameter.Parameter;
import com.ibm.aurora.rare.core.rule.RulesLibrary;
import com.ibm.aurora.rare.vcv5lib.parameters.ExtractNodeWithReplace;
import com.ibm.aurora.rare.vcv5lib.parameters.HasSpecPath;
import com.ibm.aurora.rare.vcv5lib.parameters.ScopeSpecPath;
import com.ibm.aurora.rare.vcv5lib.parameters.SpecAttribute;
import com.ibm.aurora.rare.vcv5lib.parameters.SpecNode;
import com.ibm.aurora.rare.vcv5lib.parameters.V5Palette;
import com.ibm.aurora.rare.vcv5lib.parameters.ValueRule;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public abstract class VCV5Lib
implements IRARELibrary {
    private static final String RESOURCE_RULES = "/rules/VCV5Lib_rules.xml";
    public static final String ROOT_PATH = "../templates/rare/viscoach/";

    public InputStream getRules() {
        return this.getClass().getResourceAsStream(RESOURCE_RULES);
    }

    public Map<String, IIndividualParameterFactory> getParameterFactories(final RulesLibrary rulesLibrary) {
        HashMap<String, IIndividualParameterFactory> parameterFactories = new HashMap<String, IIndividualParameterFactory>();
        parameterFactories.put("specAttribute", new IIndividualParameterFactory(){

            public Parameter createVisParameter(String name, Map<String, String> attributes) throws ParameterCreationException {
                return new SpecAttribute(name, rulesLibrary, attributes);
            }
        });
        parameterFactories.put("specNode", new IIndividualParameterFactory(){

            public Parameter createVisParameter(String name, Map<String, String> attributes) throws ParameterCreationException {
                return new SpecNode(name, rulesLibrary, attributes);
            }
        });
        parameterFactories.put("v5palette", new IIndividualParameterFactory(){

            public Parameter createVisParameter(String name, Map<String, String> attributes) throws ParameterCreationException {
                return new V5Palette(name, rulesLibrary, attributes);
            }
        });
        parameterFactories.put("extractV5NodeWithValueReplace", new IIndividualParameterFactory(){

            public Parameter createVisParameter(String name, Map<String, String> attributes) throws ParameterCreationException {
                return new ExtractNodeWithReplace(name, attributes);
            }
        });
        parameterFactories.put("scopeSpecPath", new IIndividualParameterFactory(){

            public Parameter createVisParameter(String name, Map<String, String> attributes) throws ParameterCreationException {
                return new ScopeSpecPath(name, rulesLibrary, attributes);
            }
        });
        parameterFactories.put("hasSpecPath", new IIndividualParameterFactory(){

            public Parameter createVisParameter(String name, Map<String, String> attributes) throws ParameterCreationException {
                return new HasSpecPath(name, rulesLibrary, attributes);
            }
        });
        parameterFactories.put("valueRule", new IIndividualParameterFactory(){

            public Parameter createVisParameter(String name, Map<String, String> attributes) throws ParameterCreationException {
                return new ValueRule(name, rulesLibrary, attributes);
            }
        });
        return parameterFactories;
    }

    public boolean hasRules() {
        return true;
    }

    public boolean hasParameterFactories() {
        return true;
    }
}

