/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.rare.vcv5lib.input;

import com.ibm.aurora.rare.IInputManager;
import com.ibm.aurora.rare.core.exception.XMLParsingException;
import com.ibm.aurora.rare.core.inputs.InputScopeObject;
import com.ibm.aurora.rare.core.utils.XMLHelperD4J;
import com.ibm.aurora.rare.logging.ELogLevel;
import com.ibm.aurora.rare.logging.ILogger;
import com.ibm.aurora.rare.logging.LoggingManager;
import com.ibm.aurora.rare.smdrules.input.AssociativeModelInputManager;
import com.ibm.aurora.rare.smdrules.input.InputScopeList;
import com.ibm.aurora.rare.vcv5lib.input.XMLScopeObject;
import com.ibm.cognos.aurora.api.model.IAssociativeModel;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Namespace;

public class V5InputManager
extends AssociativeModelInputManager {
    public static final String INPUT_SCOPE_TYPE_SPEC = "spec";
    private Document _v5;
    private Namespace _namespace = null;
    private String _containerName;

    public V5InputManager(IAssociativeModel model, Document v5Input, String containerName) throws XMLParsingException {
        this(model, v5Input, containerName, null);
    }

    public V5InputManager(IAssociativeModel model, Document v5Input, String containerName, ILogger logger) throws XMLParsingException {
        super(model, null, logger);
        LoggingManager loggingManager = this.getLoggingManager();
        if (loggingManager.canLog(ELogLevel.INFO)) {
            XMLHelperD4J xmlHelper = new XMLHelperD4J();
            loggingManager.getLogger().beginSection((Object)"V5InputManager Initializing");
            loggingManager.getLogger().info((Object)("Container name: " + containerName));
            loggingManager.getLogger().beginSection((Object)"V5");
            loggingManager.getLogger().info((Object)xmlHelper.docToString(v5Input));
            loggingManager.getLogger().endSection((Object)"V5");
        }
        this._containerName = containerName;
        this._v5 = v5Input;
        Element rootNode = this._v5.getRootElement();
        List declaredNamespaces = rootNode.declaredNamespaces();
        for (Namespace ns : declaredNamespaces) {
            if (ns.getURI().indexOf("http://developer.cognos.com/schemas/report/") != 0) continue;
            this._namespace = ns;
            break;
        }
        ((InputScopeList)this.getRootScope()).putScope(INPUT_SCOPE_TYPE_SPEC, (InputScopeObject)new XMLScopeObject((IInputManager)this, this.getContainerFromV5Input(v5Input)));
        if (loggingManager.canLog(ELogLevel.INFO)) {
            loggingManager.getLogger().endSection((Object)"V5InputManager Initializing");
        }
    }

    public V5InputManager(IAssociativeModel model, String v5Input, String containerName) throws XMLParsingException {
        this(model, v5Input, containerName, null);
    }

    public V5InputManager(IAssociativeModel model, String v5Input, String containerName, ILogger logger) throws XMLParsingException {
        this(model, XMLHelperD4J.getParsedDocument((String)v5Input), containerName, logger);
    }

    public Element getContainerFromV5Input(Document V5Input) throws XMLParsingException {
        Element container = (Element)V5Input.selectSingleNode("report/*[local-name() = 'layouts']/*[local-name() = 'layout']/*[local-name() = 'reportPages']/descendant::*[local-name() = 'page']/*[local-name() = 'pageBody']/descendant::*[local-name() = 'contents']/descendant::*[@name='" + this._containerName + "']");
        return container;
    }

    public Document getV5() {
        return this._v5;
    }

    public Namespace getV5Namespace() {
        return this._namespace;
    }
}

