/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.rare.vcv5lib.output;

import com.ibm.aurora.rare.core.exception.OutputResolutionException;
import com.ibm.aurora.rare.core.exception.XMLParsingException;
import com.ibm.aurora.rare.core.utils.XMLHelperD4J;
import com.ibm.aurora.rare.logging.ELogLevel;
import com.ibm.aurora.rare.logging.ILogger;
import com.ibm.aurora.rare.logging.LoggingManager;
import com.ibm.aurora.rare.smdrules.output.LocalizableOutputManager;
import com.ibm.aurora.rare.vcv5lib.input.V5InputManager;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Namespace;

public class V5OutputManager
extends LocalizableOutputManager {
    public static final String OUTPUT_V5 = "default";
    private final V5InputManager _inputManager;

    public V5OutputManager(V5InputManager inputManager, String locale) {
        this(inputManager, locale, null);
    }

    public V5OutputManager(V5InputManager inputManager, String locale, ILogger logger) {
        super(locale, "vcv5lib", logger);
        LoggingManager loggingManager = this.getLoggingManager();
        if (loggingManager.canLog(ELogLevel.INFO)) {
            loggingManager.getLogger().beginSection((Object)"V5OutputManager Initializing");
        }
        this._inputManager = inputManager;
        if (loggingManager.canLog(ELogLevel.INFO)) {
            loggingManager.getLogger().endSection((Object)"V5OutputManager Initializing");
        }
    }

    public StringBuilder resolveOutput(StringBuilder resolvedTemplate, String outputName) throws OutputResolutionException {
        if (OUTPUT_V5.equals(outputName)) {
            Document copyOfInputDocument = this.getCopyOfV5InputDocument();
            try {
                Element resolvedTemplateNode;
                if (resolvedTemplate.length() != 0 && (resolvedTemplateNode = XMLHelperD4J.getParsedDocument((String)this.fixupNamespace(resolvedTemplate).toString()).getRootElement()) != null) {
                    Element containerNode = this._inputManager.getContainerFromV5Input(copyOfInputDocument);
                    resolvedTemplateNode.detach();
                    resolvedTemplateNode.setDocument(copyOfInputDocument);
                    Element containerParent = containerNode.getParent();
                    List childList = containerParent.elements();
                    int index = childList.indexOf(containerNode);
                    if (index != -1) {
                        childList.remove(index);
                        childList.add(index, resolvedTemplateNode);
                    } else {
                        throw new OutputResolutionException("Unable to add newchild to V5Document");
                    }
                }
                return new StringBuilder(copyOfInputDocument.asXML());
            }
            catch (XMLParsingException e) {
                throw new OutputResolutionException((Exception)((Object)e));
            }
        }
        return super.resolveOutput(resolvedTemplate, outputName);
    }

    private StringBuilder fixupNamespace(StringBuilder input) {
        String nsuri;
        Namespace namespace = this._inputManager.getV5Namespace();
        if (namespace != null && (nsuri = this._inputManager.getV5Namespace().getURI()) != null && !nsuri.isEmpty() && input.indexOf(nsuri) == -1) {
            int idx = input.indexOf(">");
            input.insert(idx, " xmlns=\"" + this._inputManager.getV5Namespace().getURI() + "\"");
        }
        return input;
    }

    private Document getCopyOfV5InputDocument() {
        Document v5Doc = this._inputManager.getV5();
        return (Document)v5Doc.clone();
    }
}

