/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.rare.vcv5lib.parameters;

import com.ibm.aurora.rare.IVariationsInitializationHandle;
import com.ibm.aurora.rare.core.exception.ParameterCreationException;
import com.ibm.aurora.rare.core.exception.ParameterResolutionException;
import com.ibm.aurora.rare.core.exception.XMLParsingException;
import com.ibm.aurora.rare.core.inputs.InputScopeObject;
import com.ibm.aurora.rare.core.parameter.DependentParameter;
import com.ibm.aurora.rare.core.parameter.Parameter;
import com.ibm.aurora.rare.core.parameter.interfaces.IResolvableParameter;
import com.ibm.aurora.rare.core.parameter.interfaces.IValueParameter;
import com.ibm.aurora.rare.core.utils.XMLHelperD4J;
import com.ibm.aurora.rare.smdrules.input.InputScopeList;
import com.ibm.aurora.rare.vcv5lib.input.XMLScopeObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.dom4j.Node;

public class ExtractNodeWithReplace
extends DependentParameter
implements IValueParameter,
IResolvableParameter {
    public static final String type = "extractV5NodeWithValueReplace";
    public static final String replace = "replace";
    public static final String values = "values";
    private String _replace = null;
    private List<String> _values = null;
    private List<String> _replacePaths = null;
    private String _value;
    private XMLScopeObject _scopeObj = null;
    private boolean _isResolved = false;
    private IVariationsInitializationHandle _handle = null;

    public ExtractNodeWithReplace(String name, Map<String, String> attributes) throws ParameterCreationException {
        super(name, attributes);
        if (attributes == null) {
            attributes = new HashMap<String, String>();
        }
        if (!attributes.containsKey("nodeName")) {
            attributes.put("nodeName", this.getName());
        }
        if (attributes.containsKey(replace)) {
            this._replace = attributes.get(replace);
            this._replacePaths = this.tokenizeList(this._replace);
        }
        if (attributes.containsKey(values)) {
            this._values = this.tokenizeList(attributes.get(values));
        } else if (this.getDependentParametersNames() == null || this.getDependentParametersNames().size() != this._replacePaths.size()) {
            throw new ParameterCreationException("missmatch between number of dependent parameters and number of attribute paths.", this.getName());
        }
    }

    public ExtractNodeWithReplace(ExtractNodeWithReplace parameter) {
        super((DependentParameter)parameter);
        this._replacePaths = parameter._replacePaths;
        this._value = parameter._value;
        this._isResolved = parameter._isResolved;
        this._scopeObj = parameter._scopeObj;
        this._handle = parameter._handle;
        this._values = parameter._values;
    }

    protected Parameter copyImpl() throws ParameterCreationException {
        ExtractNodeWithReplace copy = new ExtractNodeWithReplace(this);
        return copy;
    }

    public String valueToString() throws ParameterResolutionException {
        Element node = null;
        this._value = "";
        if (this._scopeObj != null) {
            XMLHelperD4J xmlHelper = (XMLHelperD4J)this._handle.getResource(XMLHelperD4J.class);
            node = this.getNodeFromPath(this._scopeObj.getNode(), this.getAttribute("nodeName"), xmlHelper);
            if (this._values == null) {
                List dependentParameters = this.getDependentParameters();
                this._values = new ArrayList<String>();
                for (int i = 0; i < this._replacePaths.size(); ++i) {
                    Parameter dependentParam = (Parameter)dependentParameters.get(i);
                    if (!IValueParameter.class.isInstance(dependentParam)) continue;
                    this._values.add(((IValueParameter)dependentParam).valueToString());
                }
            }
            node = (Element)node.clone();
            for (int i = 0; i < this._replacePaths.size(); ++i) {
                this.replaceAttributeWithValue(node, this._replacePaths.get(i), this._values.get(i), xmlHelper);
            }
            try {
                this._value = ((XMLHelperD4J)this._handle.getResource(XMLHelperD4J.class)).nodeToString((Node)node);
            }
            catch (XMLParsingException e) {
                throw new ParameterResolutionException(this.getName(), (Exception)((Object)e));
            }
        }
        return this._value;
    }

    public boolean isResolved() {
        return this._isResolved;
    }

    public void resolve(IVariationsInitializationHandle handle, InputScopeObject scopeList) throws ParameterResolutionException {
        this._scopeObj = (XMLScopeObject)((InputScopeList)scopeList).getScope("spec");
        this._handle = handle;
        this._isResolved = true;
    }

    private void replaceAttributeWithValue(Element node, String path, String value, XMLHelperD4J xmlHelper) throws ParameterResolutionException {
        StringTokenizer tokens = new StringTokenizer(path, ".", false);
        String attribute = tokens.nextToken();
        Element currentNode = node;
        while (tokens.hasMoreTokens()) {
            try {
                currentNode = xmlHelper.getChildElementChecked(currentNode, attribute, null);
            }
            catch (XMLParsingException e) {
                throw new ParameterResolutionException(this.getName(), (Exception)((Object)e));
            }
            attribute = tokens.nextToken();
        }
        Attribute attributeNode = currentNode.attribute(attribute);
        if (attributeNode == null) {
            throw new ParameterResolutionException("attribute (" + attribute + ") does not exist", this.getName());
        }
        attributeNode.setValue(value);
    }

    private Element getNodeFromPath(Element root, String path, XMLHelperD4J xmlHelper) throws ParameterResolutionException {
        StringTokenizer tokens = new StringTokenizer(path, ".", false);
        Element currentNode = root;
        while (tokens.hasMoreTokens()) {
            try {
                if ((currentNode = xmlHelper.getChildElement(currentNode, tokens.nextToken(), null)) != null) continue;
                throw new XMLParsingException("Expected element");
            }
            catch (XMLParsingException e) {
                throw new ParameterResolutionException(this.getName(), (Exception)((Object)e));
            }
        }
        return currentNode;
    }

    public boolean validateMatchesAttributes(Map<String, String> attributes) {
        boolean validates = true;
        if (!attributes.containsKey(replace)) {
            validates = false;
        }
        if (!this._replace.equals(attributes.get(replace))) {
            validates = false;
        }
        return validates && super.validateMatchesAttributes(attributes);
    }

    public String toString() {
        try {
            return this.valueToString();
        }
        catch (ParameterResolutionException e) {
            return e.toString();
        }
    }
}

