/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.rare.vcv5lib.rules;

import com.ibm.aurora.rare.IVariationsInitializationHandle;
import com.ibm.aurora.rare.core.exception.RuleException;
import com.ibm.aurora.rare.core.exception.XMLParsingException;
import com.ibm.aurora.rare.core.inputs.InputScopeObject;
import com.ibm.aurora.rare.core.rule.IStringRule;
import com.ibm.aurora.rare.core.utils.XMLHelperD4J;
import com.ibm.aurora.rare.smdrules.input.InputScopeList;
import com.ibm.aurora.rare.smdrules.rules.BaseRule;
import com.ibm.aurora.rare.smdrules.utils.RulesUtil;
import com.ibm.aurora.rare.vcv5lib.input.XMLScopeObject;
import com.ibm.aurora.rare.vcv5lib.rules.ScopeToXMLPath;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Element;

public class ExtractXMLNode
extends BaseRule
implements IStringRule {
    public static final String PROPERTY_NODE_NAME = "nodeName";
    public static final String PROPERTY_OPTIONAL = "optional";
    protected String _nodeName = null;
    protected boolean _optional = false;

    public void setProperties(Map<String, String> properties) {
        super.setProperties(properties);
        this._nodeName = RulesUtil.getAttribute((String)PROPERTY_NODE_NAME, properties, (String)this._nodeName);
        this._optional = RulesUtil.getAttribute((String)PROPERTY_OPTIONAL, properties, (boolean)this._optional);
    }

    public String apply(List<? extends InputScopeObject> inputs, Map<String, String> attributes, IVariationsInitializationHandle handle) throws RuleException {
        Element childElement;
        String nodeName;
        block10: {
            nodeName = this._nodeName;
            if (attributes != null) {
                if (attributes.containsKey(PROPERTY_NODE_NAME)) {
                    nodeName = attributes.get(PROPERTY_NODE_NAME);
                }
                if (attributes.containsKey(PROPERTY_OPTIONAL)) {
                    this._optional = attributes.get(PROPERTY_OPTIONAL).equals("true");
                }
            }
            if (nodeName == null) {
                throw new RuleException("ExtractXMLNode", "attribute: nodeName is missing");
            }
            if (inputs.isEmpty()) {
                throw new RuleException("ExtractXMLNode", "no inputs provided to the rule");
            }
            ScopeToXMLPath scopeRule = new ScopeToXMLPath();
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("path", nodeName);
            scopeRule.setProperties(properties);
            childElement = null;
            try {
                InputScopeObject scopePath = (InputScopeObject)scopeRule.apply((List)inputs, (Map)attributes, handle).get(0);
                childElement = ((XMLScopeObject)((InputScopeList)scopePath).getScope("spec")).getNode();
            }
            catch (RuleException re) {
                if (this._optional) break block10;
                throw re;
            }
        }
        if (childElement == null) {
            return "";
        }
        try {
            return ((XMLHelperD4J)handle.getResource(XMLHelperD4J.class)).nodeToString(childElement);
        }
        catch (XMLParsingException e) {
            throw new RuleException("ExtractXMLNode", "could not serialize child node " + nodeName + "as a string");
        }
    }
}

