/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.rare.vcv5lib.rules;

import com.ibm.aurora.rare.IVariationsInitializationHandle;
import com.ibm.aurora.rare.core.exception.RuleException;
import com.ibm.aurora.rare.core.inputs.InputScopeObject;
import com.ibm.aurora.rare.core.rule.IBooleanRule;
import com.ibm.aurora.rare.smdrules.input.AssociativeModelNodeScopeObject;
import com.ibm.aurora.rare.smdrules.input.AssociativeModelScopeIterator;
import com.ibm.aurora.rare.smdrules.rules.BaseRule;
import java.util.List;
import java.util.Map;

public class ValidateManyEdgesOrSingleEdgeAndManyDimensions
extends BaseRule
implements IBooleanRule {
    public static final String PROPERTY_ISEDGE = "isEdge";
    public static final String PROPERTY_ISMEASURE = "isMeasure";

    public Boolean apply(List<? extends InputScopeObject> inputs, Map<String, String> attributes, IVariationsInitializationHandle handle) throws RuleException {
        int countEdges = 0;
        int countCategoryDimensions = 0;
        for (InputScopeObject inputScopeObject : inputs) {
            AssociativeModelScopeIterator itr = new AssociativeModelScopeIterator(inputScopeObject);
            while (itr.hasNext()) {
                AssociativeModelNodeScopeObject node = this.getAssociativeModelNodeScopeObject(itr.next());
                String isEdge = node.getProperty(PROPERTY_ISEDGE);
                String isMeasure = node.getProperty(PROPERTY_ISMEASURE);
                if (isEdge != null && isEdge.equals("true")) {
                    ++countEdges;
                    continue;
                }
                if (isMeasure != null && isMeasure.equals("true")) continue;
                ++countCategoryDimensions;
            }
        }
        return countEdges >= 2 || countEdges == 1 && countCategoryDimensions > 1;
    }
}

