/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.rare.vcv5lib.rules.map;

import com.ibm.aurora.rare.core.exception.RAREException;
import com.ibm.aurora.rare.core.inputs.InputScopeObject;
import com.ibm.aurora.rare.smdrules.input.AssociativeModelNodeScopeObject;
import com.ibm.aurora.rare.smdrules.input.AssociativeModelScopeIterator;
import com.ibm.aurora.rare.smdrules.input.InputScopeList;
import com.ibm.cognos.aurora.api.model.IDataItem;
import com.ibm.cognos.aurora.api.model.value.IValue;
import com.ibm.cognos.aurora.api.query.data.IValueIterator;
import com.ibm.cognos.smd.geoInfo.MapRecommendation;
import com.ibm.cognos.smd.geoInfo.MapRecommender;
import java.util.ArrayList;
import java.util.List;

public class MapRulesUtility {
    protected MapRulesUtility() throws RAREException {
        throw new RAREException("MapRulesUtility is a static class and should not be initialized");
    }

    static InputScopeList getRegionLocationOnMap(InputScopeList input) {
        List<InputScopeList> inputPath = MapRulesUtility.findLowestLevelPath(input);
        InputScopeList currentLevel = inputPath.get(0);
        MapRecommendation mapRecommendation = MapRulesUtility.getMapRecommendation((AssociativeModelNodeScopeObject)currentLevel.getScope("model"));
        if (MapRulesUtility.hasPointLocation(mapRecommendation)) {
            String pointFileName = MapRulesUtility.getMapFile(mapRecommendation);
            for (int i = 1; i < inputPath.size(); ++i) {
                InputScopeList level = inputPath.get(i);
                AssociativeModelNodeScopeObject levelObj = (AssociativeModelNodeScopeObject)level.getScope("model");
                if (!levelObj.hasNode() || !MapRulesUtility.hasRegionLocation(mapRecommendation = MapRulesUtility.getMapRecommendation(levelObj)) || !pointFileName.equals(MapRulesUtility.getMapFile(mapRecommendation))) continue;
                return level;
            }
            return null;
        }
        if (MapRulesUtility.hasRegionLocation(mapRecommendation)) {
            return currentLevel;
        }
        return null;
    }

    static InputScopeList getPointLocationOnMap(InputScopeList input) {
        MapRecommendation mapRecommendation;
        InputScopeList lowestInput = MapRulesUtility.findLowestLevel(input);
        AssociativeModelNodeScopeObject lowestLevel = (AssociativeModelNodeScopeObject)lowestInput.getScope("model");
        if (lowestLevel.hasNode() && MapRulesUtility.hasPointLocation(mapRecommendation = MapRulesUtility.getMapRecommendation(lowestLevel))) {
            return lowestInput;
        }
        return null;
    }

    static MapRecommendation getMapRecommendation(AssociativeModelNodeScopeObject associativeModelNodeScopeObject) {
        List<String> locations = MapRulesUtility.fetchLocationLabels(associativeModelNodeScopeObject);
        return MapRecommender.getInstance().recommendMap(locations);
    }

    static boolean hasRegionLocation(MapRecommendation mapRecommendation) {
        return mapRecommendation.mapExists() && !mapRecommendation.hasRegionName();
    }

    static boolean hasPointLocation(MapRecommendation mapRecommendation) {
        return mapRecommendation.mapExists() && mapRecommendation.hasRegionName();
    }

    static List<String> fetchLocationLabels(AssociativeModelNodeScopeObject associativeModelNodeScopeObject) {
        ArrayList<String> locations = new ArrayList<String>();
        if (associativeModelNodeScopeObject.getDataItem() != null && associativeModelNodeScopeObject.getConcept().isGeographic()) {
            IDataItem locationDataItem = associativeModelNodeScopeObject.getDataItem();
            IValueIterator values = locationDataItem.fetchUniqueValues(30L);
            while (values.hasNext()) {
                IValue val = values.next();
                if (locationDataItem.getProperty("label").getFormattedValue().contains(val.getFormattedValue())) continue;
                locations.add(val.getFormattedValue());
            }
        }
        return locations;
    }

    static InputScopeList findLowestLevel(InputScopeList input) {
        AssociativeModelScopeIterator itr = new AssociativeModelScopeIterator((InputScopeObject)input);
        while (itr.hasNext()) {
            InputScopeList current = itr.next();
            AssociativeModelNodeScopeObject currentNode = (AssociativeModelNodeScopeObject)current.getScope("model");
            if (currentNode.isMetric()) continue;
            return MapRulesUtility.findLowestLevel(current);
        }
        return input;
    }

    static List<InputScopeList> findLowestLevelPath(InputScopeList input) {
        AssociativeModelScopeIterator itr = new AssociativeModelScopeIterator((InputScopeObject)input);
        ArrayList<InputScopeList> path = new ArrayList<InputScopeList>();
        while (itr.hasNext()) {
            InputScopeList current = itr.next();
            AssociativeModelNodeScopeObject currentNode = (AssociativeModelNodeScopeObject)current.getScope("model");
            if (currentNode.isMetric()) continue;
            path.addAll(MapRulesUtility.findLowestLevelPath(current));
            break;
        }
        path.add(input);
        return path;
    }

    static String getMapPointSize(List<String> locations) {
        if (locations.size() > 0 && locations.size() < 6) {
            return "12";
        }
        if (locations.size() > 5 && locations.size() < 10) {
            return "8";
        }
        return "5";
    }

    static String getMapFile(MapRecommendation mapRecommendation) {
        if (mapRecommendation.mapExists()) {
            return mapRecommendation.getMapName() + ".cmf";
        }
        return null;
    }

    static String getMapRegion(MapRecommendation mapRecommendation) {
        if (mapRecommendation.mapExists()) {
            if (mapRecommendation.hasRegionName()) {
                return mapRecommendation.getRegionName() + ".TAB";
            }
            return mapRecommendation.getLayerName() + ".TAB";
        }
        return null;
    }

    static String getMapPoint(MapRecommendation mapRecommendation) {
        if (mapRecommendation.mapExists()) {
            return mapRecommendation.getLayerName() + ".TAB";
        }
        return null;
    }
}

