/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.vis.vgs.atom;

import com.ibm.ba.vis.vgs.atom.VisEntryWriter;
import com.ibm.ba.vis.vgs.atom.VisEntryWriterFactory;
import com.ibm.ba.vis.vgs.bundle.NullBundle;
import com.ibm.ba.vis.vgs.bundle.VisResource;
import com.ibm.ba.vis.vgs.gallery.GalleryResponder;
import com.ibm.ba.vis.vgs.gallery.cache.ResultPage;
import com.ibm.cognos.rs.core.Status;
import com.ibm.cognos.rs.core.WebApplicationException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.abdera.Abdera;
import org.apache.abdera.writer.StreamWriter;
import org.apache.abdera.writer.WriterFactory;
import org.apache.commons.lang.StringUtils;

public class AtomResponder
implements GalleryResponder {
    static final String GALLERY_TITLE = "Visualization Gallery";
    static final String VIS_DEFINITION_MIME = "application/vnd.vis.ibm.com.definition";
    static final String REL_VIS_ADAPTER = "vis.adapter";
    static final String REL_VIS_IMPLEMENTATION = "vis.implementation";
    static final String REL_VIS_DEFINITION = "vis.definition";
    static final String DEFAULT_AUTHOR = "ibm.com";
    private static final int DEFAULT_START_INDEX = 0;
    private final WriterFactory writerFactory;
    private final VisEntryWriterFactory entryWriterFactory;

    public AtomResponder() {
        this(Abdera.getNewWriterFactory(), new VisEntryWriterFactory());
    }

    AtomResponder(WriterFactory writerFactory, VisEntryWriterFactory entryWriterFactory) {
        this.writerFactory = writerFactory;
        this.entryWriterFactory = entryWriterFactory;
    }

    @Override
    public InputStream respond(URI baseURI, URI entryBaseURI, ResultPage<? extends VisResource> resultPage, String language, String timezoneID, String extraInfo, String category) {
        try {
            StreamWriter feedWriter = this.writerFactory.newStreamWriter();
            feedWriter.setAutoclose(true);
            feedWriter.setAutoflush(true);
            feedWriter.setAutoIndent(true);
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            feedWriter.setOutputStream((OutputStream)buffer);
            this.writeFeedPreamble(feedWriter, baseURI, resultPage, language);
            for (VisResource visResource : resultPage) {
                if (visResource instanceof NullBundle) continue;
                this.writeEntry(feedWriter, visResource, entryBaseURI, false, language, timezoneID, extraInfo, category);
            }
            this.writeFeedPostamble(feedWriter);
            buffer.flush();
            String bufferStr = buffer.toString("UTF-8").replaceAll("xmlns=\"\"", "");
            return new ByteArrayInputStream(bufferStr.getBytes("UTF-8"));
        }
        catch (IOException e) {
            throw new WebApplicationException(e, Status.INTERNAL_SERVER_ERROR);
        }
    }

    @Override
    public InputStream respond(URI baseURI, VisResource resource, String language, String timezoneID, String extraInfo, String category) {
        try {
            StreamWriter feedWriter = this.writerFactory.newStreamWriter();
            feedWriter.setAutoclose(true);
            feedWriter.setAutoflush(true);
            feedWriter.setAutoIndent(true);
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            feedWriter.setOutputStream((OutputStream)buffer);
            feedWriter.startDocument();
            this.writeEntry(feedWriter, resource, baseURI, true, language, timezoneID, extraInfo, category);
            feedWriter.endDocument();
            buffer.flush();
            String bufferStr = buffer.toString("UTF-8").replaceAll("xmlns=\"\"", "");
            return new ByteArrayInputStream(bufferStr.getBytes("UTF-8"));
        }
        catch (IOException e) {
            throw new WebApplicationException(e, Status.INTERNAL_SERVER_ERROR);
        }
    }

    private <T extends VisResource> void writeEntry(StreamWriter feedWriter, T visResource, URI entryBaseURI, boolean full, String language, String timezoneID, String extraInfo, String category) {
        VisEntryWriter<?> entryWriter = this.entryWriterFactory.newWriter(visResource.getClass(), feedWriter, full, language, timezoneID, extraInfo, category);
        entryWriter.writeEntry(visResource, entryBaseURI);
    }

    private void writeFeedPreamble(StreamWriter feedWriter, URI baseURI, ResultPage<? extends VisResource> resultPage, String language) {
        feedWriter.startDocument();
        feedWriter.startFeed();
        feedWriter.writeId("vis.ibm.com:2013:gallery");
        feedWriter.writeTitle(GALLERY_TITLE);
        feedWriter.writeAuthor(DEFAULT_AUTHOR);
        feedWriter.writeUpdated(new Date());
        feedWriter.writeLink(this.getSelfLink(baseURI, resultPage, language), "self", "application/atom+xml");
        feedWriter.writeLink(this.getFirstLink(baseURI, resultPage, language), "first", "application/atom+xml");
        if (resultPage.hasPrevious()) {
            feedWriter.writeLink(this.getPrevLink(baseURI, resultPage, language), "previous", "application/atom+xml");
        }
        if (resultPage.hasNext()) {
            feedWriter.writeLink(this.getNextLink(baseURI, resultPage, language), "next", "application/atom+xml");
        }
    }

    private String getSelfLink(URI baseURI, ResultPage<?> resultPage, String language) {
        StringBuilder sb = new StringBuilder();
        sb.append(baseURI);
        this.appendQueryParams(sb, language, resultPage.getStartIndex(), resultPage.getPageSize());
        return sb.toString();
    }

    private String getFirstLink(URI baseURI, ResultPage<?> resultPage, String language) {
        StringBuilder sb = new StringBuilder();
        sb.append(baseURI);
        this.appendQueryParams(sb, language, 0, resultPage.getPageSize());
        return sb.toString();
    }

    private String getPrevLink(URI baseURI, ResultPage<?> resultPage, String language) {
        StringBuilder sb = new StringBuilder();
        sb.append(baseURI);
        int pageSize = resultPage.getPageSize();
        int startIndex = resultPage.getStartIndex() - pageSize;
        startIndex = startIndex < 0 ? 0 : startIndex;
        this.appendQueryParams(sb, language, startIndex, pageSize);
        return sb.toString();
    }

    private String getNextLink(URI baseURI, ResultPage<?> resultPage, String language) {
        StringBuilder sb = new StringBuilder();
        sb.append(baseURI);
        int pageSize = resultPage.getPageSize();
        int startIndex = resultPage.getStartIndex() + pageSize;
        this.appendQueryParams(sb, language, startIndex, pageSize);
        return sb.toString();
    }

    private StringBuilder appendQueryParams(StringBuilder sb, String lang, int startIndex, int pageSize) {
        LinkedHashMap<String, Object> queryParams = new LinkedHashMap<String, Object>(3, 1.0f);
        if (startIndex >= 0) {
            queryParams.put("si", startIndex);
        }
        if (pageSize > 0) {
            queryParams.put("ps", pageSize);
        }
        if (StringUtils.isNotEmpty((String)lang)) {
            queryParams.put("lang", lang);
        }
        if (queryParams.size() > 0) {
            sb.append("?");
            for (Map.Entry entry : queryParams.entrySet()) {
                sb.append((String)entry.getKey()).append("=").append(entry.getValue());
                sb.append("&");
            }
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb;
    }

    private void writeFeedPostamble(StreamWriter feedWriter) {
        feedWriter.endFeed();
        feedWriter.endDocument();
    }
}

