/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.vis.vgs.atom;

import com.ibm.ba.vis.vgs.atom.VisEntryWriter;
import com.ibm.ba.vis.vgs.bundle.VisResource;
import java.net.URI;
import org.apache.abdera.writer.StreamWriter;
import org.apache.commons.lang.StringUtils;

abstract class BaseEntryWriter<T extends VisResource>
implements VisEntryWriter<T> {
    private final String resourcePrefix;
    private final StreamWriter feedWriter;
    private final String language;
    private final String extraInfo;
    protected final String category;

    BaseEntryWriter(String resourcePrefix, StreamWriter feedWriter, String language, String extraInfo, String category) {
        this.resourcePrefix = resourcePrefix;
        this.feedWriter = feedWriter;
        this.language = language;
        this.extraInfo = extraInfo;
        this.category = category;
    }

    String getResourcePrefix() {
        return this.resourcePrefix;
    }

    StreamWriter getFeedWriter() {
        return this.feedWriter;
    }

    String getLanguage() {
        return this.language;
    }

    String getCategory() {
        return this.category;
    }

    String getExtraInfo() {
        return this.extraInfo == null ? "" : this.extraInfo;
    }

    @Override
    public void writeEntry(T visResource, URI requestURI) {
        if (this.isValid(visResource)) {
            this.addAfterVerify(visResource, requestURI);
        }
    }

    protected boolean isValid(T visResource) {
        return visResource != null;
    }

    private void addAfterVerify(T visResource, URI requestURI) {
        this.getFeedWriter().startEntry();
        String resourceName = visResource.getName(this.getLanguage());
        String resourceId = visResource.getId();
        if (StringUtils.isNotEmpty((String)resourceName)) {
            this.getFeedWriter().writeTitle(resourceName);
        } else {
            this.getFeedWriter().writeTitle(resourceId);
        }
        this.getFeedWriter().writeId(resourceId);
        this.writeEntryInfo(visResource);
        if (this.hasLinks()) {
            this.writeEntryLinks(visResource, requestURI);
        }
        this.getFeedWriter().endEntry();
    }

    abstract void writeEntryInfo(T var1);

    abstract void writeEntryLinks(T var1, URI var2);

    boolean hasLinks() {
        return this.resourcePrefix != null;
    }

    String buildLinkURI(VisResource visResource, URI requestURI) {
        StringBuilder sb = new StringBuilder();
        sb.append(requestURI.getPath());
        if ('/' != sb.charAt(sb.length() - 1)) {
            sb.append('/');
        }
        sb.append(this.getResourcePrefix()).append(visResource.getId());
        return sb.toString();
    }

    String getLangQueryParam(String language) {
        return language == null ? "" : "?lang=" + this.getLanguage();
    }

    String getExtraInfoQueryParam(String extraInfo) {
        return extraInfo == null ? "" : "?extraInfo=" + this.getLanguage();
    }
}

