/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.vis.vgs.atom;

import com.ibm.ba.vis.schema.definition.Rave2BundleDefinitionManager;
import com.ibm.ba.vis.vgs.atom.BaseEntryWriter;
import com.ibm.ba.vis.vgs.bundle.I18NString;
import com.ibm.ba.vis.vgs.bundle.Image;
import com.ibm.ba.vis.vgs.bundle.VisBundle;
import java.io.InputStream;
import java.net.URI;
import java.util.Date;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.abdera.model.Text;
import org.apache.abdera.writer.StreamWriter;
import org.apache.commons.io.IOUtils;

class BundleEntryWriter
extends BaseEntryWriter<VisBundle> {
    static final String ICON_REL_TYPE = "icon";
    static final String PREVIEW_REL_TYPE = "preview";
    static final String VIS_DEFINITION_MIME = "application/vnd.vis.ibm.com.definition";
    static final String REL_VIS_ADAPTER = "vis.adapter";
    static final String REL_VIS_IMPLEMENTATION = "vis.implementation";
    static final String REL_VIS_DEFINITION = "vis.definition";
    static final String ELE_TAB_SLOTS = "slots";

    BundleEntryWriter(StreamWriter feedWriter, String language, String extraInfo, String category) {
        super("id/", feedWriter, language, extraInfo, category);
    }

    @Override
    void writeEntryInfo(VisBundle visBundle) {
        Date date;
        if (visBundle.isCustomViz()) {
            return;
        }
        String id = visBundle.getId();
        if (id.contains(",")) {
            String[] parts = id.split(",");
            this.getFeedWriter().writeText("bundleID", Text.Type.TEXT, parts[0]);
            this.getFeedWriter().writeText("configID", Text.Type.TEXT, parts[1]);
            this.getFeedWriter().writeText("label", Text.Type.TEXT, visBundle.getName(this.getLanguage()));
        }
        if ((date = visBundle.getLastUpdated()) != null) {
            this.getFeedWriter().writeUpdated(date);
        }
        this.getFeedWriter().writeSummary(visBundle.getDescription(this.getLanguage()));
        this.getFeedWriter().writeAuthor(visBundle.getAuthor());
        if (this.getExtraInfo().equals(ELE_TAB_SLOTS)) {
            this.getFeedWriter().writeText(new QName("http://www.ibm.com/xmlns/prod/ba/visBundle/chartTypeDefinition.1/", ELE_TAB_SLOTS), Text.Type.TEXT, this.readExtraDef(visBundle));
        }
        this.getFeedWriter().writeText(new QName("http://www.ibm.com/xmlns/prod/ba/visBundle/chartTypeDefinition.1/", "tooltip"), Text.Type.TEXT, visBundle.getTooltip(this.getLanguage()));
        this.getFeedWriter().writeText(new QName("http://www.ibm.com/xmlns/prod/ba/visBundle/chartTypeDefinition.1/", "outputType"), Text.Type.TEXT, visBundle.getOutputType());
    }

    private String readExtraDef(VisBundle visBundle) {
        try {
            InputStream stream = visBundle.getDefinition(this.getLanguage(), "*/*", ELE_TAB_SLOTS);
            if (stream != null) {
                return IOUtils.toString((InputStream)stream, (String)"UTF-8");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    @Override
    protected boolean isValid(VisBundle visBundle) {
        return this.hasCategory(visBundle.getTags(), this.getLanguage(), this.getCategory());
    }

    @Override
    void writeEntryLinks(VisBundle visBundle, URI requestURI) {
        if (visBundle.isCustomViz()) {
            return;
        }
        String langQueryParm = this.getLangQueryParam(this.getLanguage());
        String linkURI = this.buildLinkURI(visBundle, requestURI);
        this.getFeedWriter().writeLink(linkURI + langQueryParm, "alternate", "application/atom+xml");
        this.getFeedWriter().writeLink(linkURI + "/definition" + langQueryParm, REL_VIS_DEFINITION, VIS_DEFINITION_MIME);
        this.writeImageLinks(visBundle.getId(), linkURI, visBundle.getImages(ICON_REL_TYPE));
        this.writeTags(visBundle.getTags(), this.getLanguage());
        this.getFeedWriter().startContent("application/zip", linkURI + "/content");
        this.getFeedWriter().endContent();
    }

    private boolean hasCategory(List<I18NString> tagList, String language, String expectedCategory) {
        if (expectedCategory == null || expectedCategory.trim().length() == 0) {
            return true;
        }
        for (I18NString object : tagList) {
            if (!expectedCategory.equalsIgnoreCase(object.getValue(language))) continue;
            return true;
        }
        return false;
    }

    void writeImageLinks(String bundleName, String linkURI, List<Image> images) {
        if (Rave2BundleDefinitionManager.isRave2BundleName((String)bundleName)) {
            String path = linkURI.replace("gallery/rave2", "gallery").replace(bundleName, "../../../../../lib/rave/current") + '/' + bundleName.split(",")[0] + '/';
            List previews = Rave2BundleDefinitionManager.getRave2BundleConfigPreviews((String)bundleName);
            for (String preview : previews) {
                if (preview.endsWith("_icon_48.svg")) {
                    this.writeRave2ImageLink(path + preview, 48);
                    continue;
                }
                if (preview.endsWith("_preview_320.svg")) {
                    this.writeRave2ImageLink(path + preview, 320);
                    continue;
                }
                if (preview.endsWith("_preview_500.svg")) {
                    this.writeRave2ImageLink(path + preview, 500);
                    continue;
                }
                this.writeRave2ImageLink(path + preview, 48);
            }
        } else {
            linkURI = linkURI.replace("gallery/rave1", "gallery");
            for (Image image : images) {
                this.writeImageLink(linkURI, image);
            }
        }
    }

    private void writeRave2ImageLink(String linkURI, int size) {
        this.getFeedWriter().startElement(new QName("http://www.w3.org/2005/Atom", "link"));
        this.getFeedWriter().writeAttribute("href", linkURI);
        switch (size) {
            case 48: {
                this.getFeedWriter().writeAttribute("rel", ICON_REL_TYPE);
                this.getFeedWriter().writeAttribute("sizes", "48x48");
                break;
            }
            case 320: {
                this.getFeedWriter().writeAttribute("rel", PREVIEW_REL_TYPE);
                this.getFeedWriter().writeAttribute("sizes", "320x320");
                break;
            }
            default: {
                this.getFeedWriter().writeAttribute("rel", PREVIEW_REL_TYPE);
                this.getFeedWriter().writeAttribute("sizes", "500x500");
            }
        }
        this.getFeedWriter().writeAttribute("type", "image/svg");
        this.getFeedWriter().endElement();
    }

    private void writeImageLink(String linkURI, Image image) {
        this.getFeedWriter().startElement(new QName("http://www.w3.org/2005/Atom", "link"));
        this.getFeedWriter().writeAttribute("href", linkURI + "/images/" + image.getName());
        this.getFeedWriter().writeAttribute("rel", image.getRelType());
        this.getFeedWriter().writeAttribute("sizes", image.getSize());
        this.getFeedWriter().writeAttribute("type", image.getMimeType());
        this.getFeedWriter().endElement();
    }

    private void writeTags(List<I18NString> tags, String language) {
        for (I18NString tag : tags) {
            this.getFeedWriter().writeCategory(tag.getValue(language));
        }
    }
}

