/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.vis.vgs.atom;

import com.cognos.i18n.DateTimeFormat;
import com.cognos.i18n.TimeZone;
import com.cognos.i18n.ToolkitResources;
import com.ibm.ba.vis.vgs.atom.BundleEntryWriter;
import com.ibm.ba.vis.vgs.bundle.DataSetInfo;
import com.ibm.ba.vis.vgs.bundle.MimeMap;
import com.ibm.ba.vis.vgs.bundle.VisBundle;
import java.net.URI;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.xml.namespace.QName;
import org.apache.abdera.model.Text;
import org.apache.abdera.writer.StreamWriter;
import org.apache.commons.lang.StringUtils;

public class CompleteEntryWriter
extends BundleEntryWriter {
    private final String timezoneID;

    CompleteEntryWriter(StreamWriter feedWriter, String language, String timezoneID, String extraInfo, String category) {
        super(feedWriter, language, extraInfo, category);
        this.timezoneID = timezoneID;
    }

    @Override
    void writeEntryInfo(VisBundle visBundle) {
        if (visBundle.isCustomViz()) {
            return;
        }
        super.writeEntryInfo(visBundle);
        this.writeDataSetInfo(visBundle.getDataSetInfoList());
    }

    @Override
    void writeEntryLinks(VisBundle visBundle, URI requestURI) {
        super.writeEntryLinks(visBundle, requestURI);
        String linkURI = this.buildLinkURI(visBundle, requestURI);
        Date date = visBundle.getLastUpdated();
        if (date != null) {
            String formattedTime = this.getFormattedDateString(date);
            this.getFeedWriter().writeText(new QName("http://www.ibm.com/xmlns/prod/ba/visBundle/chartTypeDefinition.1/", "localDateTime"), Text.Type.TEXT, formattedTime);
        }
        if (!visBundle.isCustomViz()) {
            this.writeImplementationLinks(visBundle, linkURI);
            this.getFeedWriter().writeLink(linkURI + "/adapter", "vis.adapter", "text/plain");
            this.writeImageLinks(visBundle.getId(), linkURI, visBundle.getImages("preview"));
        }
    }

    private void writeImplementationLinks(VisBundle visBundle, String linkURI) {
        for (String format : visBundle.getImplementationFormats()) {
            this.getFeedWriter().writeLink(linkURI + "/implementation?fmt=" + format, "vis.implementation", MimeMap.get(format));
        }
    }

    private void writeDataSetInfo(List<DataSetInfo> dataSetInfoList) {
        for (DataSetInfo datasetInfo : dataSetInfoList) {
            this.getFeedWriter().startElement(new QName("http://www.ibm.com/xmlns/prod/ba/visBundle/chartTypeDefinition.1/", "dataSet"));
            this.getFeedWriter().writeAttribute("name", datasetInfo.getName(this.getLanguage()));
            this.getFeedWriter().writeAttribute("categoryFields", datasetInfo.getCategoryFields());
            this.getFeedWriter().writeAttribute("valueFields", datasetInfo.getValueFields());
            this.getFeedWriter().endElement();
        }
    }

    private String getFormattedDateString(Date updated) {
        TimeZone timezone = new TimeZone(this.timezoneID);
        Locale locale = StringUtils.isNotEmpty((String)this.getLanguage()) ? ToolkitResources.getLocaleFromStringID((String)this.getLanguage()) : Locale.getDefault();
        DateTimeFormat dateTime = new DateTimeFormat(locale, 11, 1, 2);
        dateTime.setTimeZone(timezone);
        return dateTime.format(updated);
    }
}

