/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.vis.vgs.atom;

import com.ctc.wstx.stax.WstxOutputFactory;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.Field;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import org.apache.abdera.Abdera;
import org.apache.abdera.parser.stax.StaxStreamWriter;
import org.apache.abdera.writer.StreamWriter;

public class WSTXStreamWriter
extends StaxStreamWriter {
    private static final Field WRITER_FIELD = WSTXStreamWriter.getWriterField();
    private static final XMLOutputFactory XML_OUTPUT_FACTORY = WSTXStreamWriter.createXMLOutputFactory();

    public WSTXStreamWriter(Abdera abdera) {
        super(abdera);
    }

    public WSTXStreamWriter(Abdera abdera, Writer writer) {
        super(abdera, writer);
    }

    public WSTXStreamWriter(Abdera abdera, OutputStream out) {
        super(abdera, out);
    }

    public WSTXStreamWriter(Abdera abdera, OutputStream out, String charset) {
        super(abdera, out, charset);
    }

    public StreamWriter setWriter(Writer writer) {
        XMLStreamWriter streamWriter;
        try {
            streamWriter = XML_OUTPUT_FACTORY.createXMLStreamWriter(writer);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.updateWriter(streamWriter);
        return this;
    }

    public StreamWriter setOutputStream(OutputStream out) {
        XMLStreamWriter streamWriter;
        try {
            streamWriter = XML_OUTPUT_FACTORY.createXMLStreamWriter(out, "UTF8");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.updateWriter(streamWriter);
        return this;
    }

    public StreamWriter setOutputStream(OutputStream out, String charset) {
        XMLStreamWriter streamWriter;
        try {
            streamWriter = XML_OUTPUT_FACTORY.createXMLStreamWriter(out, charset);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.updateWriter(streamWriter);
        return this;
    }

    private static XMLOutputFactory createXMLOutputFactory() {
        WstxOutputFactory factory = new WstxOutputFactory();
        factory.setProperty("javax.xml.stream.isRepairingNamespaces", Boolean.FALSE);
        return factory;
    }

    private static Field getWriterField() {
        try {
            Field field = StaxStreamWriter.class.getDeclaredField("writer");
            field.setAccessible(true);
            return field;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to resolve 'writer' field", e);
        }
    }

    private void updateWriter(XMLStreamWriter writer) {
        try {
            WRITER_FIELD.set((Object)this, writer);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to set 'writer' field", e);
        }
    }
}

