/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.vis.vgs.bundle;

import com.ibm.ba.vis.schema.definition.DefinitionUpgrader;
import com.ibm.ba.vis.schema.definition.DefinitionValidator;
import com.ibm.ba.vis.schema.definition.DefinitionValidatorFactory;
import com.ibm.ba.vis.vgs.gallery.fs.FileSystemVisBundle;
import com.ibm.ba.vis.vgs.parser.DefinitionParser;
import com.ibm.ba.vis.vgs.resources.ResourceManager;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

public class DefinitionManager {
    private final DefinitionParser parser;
    private final DefinitionValidatorFactory validator;
    private final DefinitionUpgrader upgrader;

    public DefinitionManager(DefinitionParser parser, DefinitionValidatorFactory validator, DefinitionUpgrader upgrader) {
        this.parser = parser;
        this.validator = validator;
        this.upgrader = upgrader;
    }

    public InputStream translate(InputStream source, String language, ResourceManager resources) throws IOException {
        return this.parser.parse(source, language, resources);
    }

    public InputStream translate(InputStream source, String language, ResourceManager resources, String element) throws IOException {
        return this.parser.parse(source, language, resources, element);
    }

    public InputStream upgrade(InputStream source) {
        return this.upgrader.upgradeToLatestVer(source);
    }

    public InputStream upgradeAndTranslate(InputStream source, String represenation, String language, ResourceManager resources) throws IOException {
        InputStream upgraded = this.upgrade(source);
        return this.translate(upgraded, language, resources);
    }

    public InputStream upgradeAndTranslate(InputStream source, String represenation, String language, ResourceManager resources, String element) throws IOException {
        InputStream upgraded = this.upgrade(source);
        return this.translate(upgraded, language, resources, element);
    }

    public void validate(FileSystemVisBundle visBundle) throws IOException {
        BufferedInputStream bis = new BufferedInputStream(visBundle.getDefinitionStream());
        if (bis.markSupported()) {
            bis.mark(512);
        }
        DefinitionValidator defValidator = this.validator.getValidatorInstance((InputStream)bis);
        if (bis.markSupported()) {
            bis.reset();
        } else {
            bis = new BufferedInputStream(visBundle.getDefinitionStream());
        }
        defValidator.validate((InputStream)bis);
    }
}

