/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.vis.vgs.config;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.pogo.pdk.Configuration;
import com.ibm.ba.vis.schema.definition.Rave2BundleDefinitionManager;
import com.ibm.ba.vis.vgs.config.VGSConfiguration;
import java.io.File;
import java.util.Map;

public class PogoConfiguration
extends VGSConfiguration {
    private static final String EMPTY_STRING = "";
    static final String VGS_TEMPFOLDER_NAME = "vgs";
    static final String DEFAULT_TEMP_PATH = "../temp";
    static final String CHARTDEF_SCHEMA_PATH = "../schemas/visualization/ChartTypeDefinition_1.xsd";
    static final String VISUALIZATION_SCHEMA_PATH = "../schemas/visualization/ChartTypeDefinition_2.xsd";
    static final String VISUALIZATION_SCHEMA_3_PATH = "../schemas/visualization/ChartTypeDefinition_3.xsd";
    static final String VISUALIZATION_SCHEMA_3_1_PATH = "../schemas/visualization/ChartTypeDefinition_3_1.xsd";
    public static final String CONFIG_PARAM_CM_URL = "contentManager";
    public static final String CONFIG_PARAM_CMREST_URL = "contentManagerRest";
    public static final String CONFIG_PARAM_CMREST_USER_URL = "contentManagerUserRest";
    public static final String CONFIG_PARAM_GATEWAY = "gateway";
    public static final String CONFIG_PARAM_LOCALES = "locales";
    private volatile Configuration pogoConfig;
    private volatile File tempFolder;

    PogoConfiguration() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reconfigure(Object config) {
        if (config instanceof Configuration) {
            Configuration pogoConfig2;
            Object object = pogoConfig2 = (Configuration)config;
            synchronized (object) {
                this.pogoConfig = pogoConfig2;
            }
            this.tempFolder = this.getConfiguredTempFolder();
            object = Rave2BundleDefinitionManager.getOneLangRave2OneBundleDefinition((String)"rave-library-column,clusteredcolumn", (String)"en");
        }
    }

    @Override
    public String getValue(String key) {
        if (this.pogoConfig != null) {
            if (CONFIG_PARAM_CMREST_USER_URL.equals(key)) {
                return this.getValue(CONFIG_PARAM_CM_URL).replaceFirst("/p2pd/servlet", "/bi/v1");
            }
            if (CONFIG_PARAM_CMREST_URL.equals(key)) {
                return this.getValue(CONFIG_PARAM_CM_URL).replaceFirst("/servlet", "/cm/1.0/objects");
            }
            if (CONFIG_PARAM_LOCALES.equals(key)) {
                return this.getLocaleList();
            }
            return this.pogoConfig.getValue(key);
        }
        return EMPTY_STRING;
    }

    private String getLocaleList() {
        String locales = "en";
        if (this.pogoConfig != null) {
            ICCLConfiguration cclConfig = this.pogoConfig.getICCLConfiguration();
            try {
                Map localeMap = cclConfig.getContentLocaleList(EMPTY_STRING);
                if (localeMap.size() > 0) {
                    StringBuilder sb = new StringBuilder();
                    for (String locale : localeMap.keySet()) {
                        sb.append(locale);
                        sb.append(",");
                    }
                    sb.deleteCharAt(sb.length() - 1);
                    locales = sb.toString();
                }
            }
            catch (CCLConfigurationException cCLConfigurationException) {
                // empty catch block
            }
        }
        return locales;
    }

    @Override
    public File getTempFolder() {
        return this.tempFolder;
    }

    private File getConfiguredTempFolder() {
        File tmpFolder = null;
        if (this.pogoConfig != null) {
            ICCLConfiguration cclConfig = this.pogoConfig.getICCLConfiguration();
            String tempPath = cclConfig.resolveEffectivePath(DEFAULT_TEMP_PATH);
            tmpFolder = new File(tempPath + '/' + VGS_TEMPFOLDER_NAME);
        }
        return tmpFolder;
    }

    @Override
    public File getChartTypeDefinitionSchema() {
        return this.getSchemaFile(CHARTDEF_SCHEMA_PATH);
    }

    @Override
    public File getVisualizationDefinitionSchema() {
        return this.getSchemaFile(VISUALIZATION_SCHEMA_PATH);
    }

    @Override
    public File getVisualizationDefinitionSchema3() {
        return this.getSchemaFile(VISUALIZATION_SCHEMA_3_PATH);
    }

    @Override
    public File getVisualizationDefinitionSchema3_1() {
        return this.getSchemaFile(VISUALIZATION_SCHEMA_3_1_PATH);
    }

    private File getSchemaFile(String path) {
        File schemaFile = null;
        if (this.pogoConfig != null) {
            ICCLConfiguration cclConfig = this.pogoConfig.getICCLConfiguration();
            String schemaPath = cclConfig.resolveEffectivePath(path);
            schemaFile = new File(schemaPath);
        }
        return schemaFile;
    }
}

