/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.vis.vgs.error;

import com.ibm.ba.vis.vgs.error.ErrorCode;
import com.ibm.cognos.rs.core.Status;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class ErrorMessage {
    private static final String SERVER_RESOURCES = "vgs";
    private static final Pattern PARAM_PATTERN = Pattern.compile("(?:[{](\\w+)[}])");
    private final ErrorCode errorCode;
    private final Map<String, String> parameters;

    public ErrorMessage(ErrorCode errorCode) {
        this.errorCode = errorCode;
        this.parameters = new HashMap<String, String>(4, 1.0f);
    }

    public String getMessageId() {
        return this.errorCode.getMessageId();
    }

    public Status getStatus() {
        return this.errorCode.getStatus();
    }

    public void addParameter(String name, String value) {
        if (StringUtils.isNotEmpty((String)name)) {
            this.parameters.put(name, value);
        }
    }

    public String getLocalizedMessage(Locale locale) {
        String value = this.getResourceValue(this.getMessageId(), locale);
        value = value == null ? this.getMessageId() : this.addParameters(value);
        return value;
    }

    private String getResourceValue(String resourceId, Locale locale) {
        String value = null;
        ResourceBundle serverResources = this.getServerResources(locale);
        if (serverResources == null) {
            serverResources = this.getServerResources(Locale.ROOT);
        }
        if (serverResources != null) {
            try {
                value = serverResources.getString(resourceId);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return value;
    }

    private ResourceBundle getServerResources(Locale locale) {
        try {
            return PropertyResourceBundle.getBundle(SERVER_RESOURCES, locale);
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    private String addParameters(String msg) {
        Matcher parameterMatcher = PARAM_PATTERN.matcher(msg);
        StringBuilder sb = new StringBuilder();
        int ptr = 0;
        while (parameterMatcher.find()) {
            String paramName = parameterMatcher.group(1);
            int end = parameterMatcher.end() - parameterMatcher.group().length();
            sb.append(msg.substring(ptr, end));
            sb.append(this.parameters.get(paramName));
            ptr = parameterMatcher.end();
        }
        if (ptr == 0) {
            return msg;
        }
        if (ptr < msg.length()) {
            sb.append(msg.substring(ptr));
        }
        return sb.toString();
    }
}

