/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.vis.vgs.error;

import com.ibm.ba.vis.vgs.error.ErrorCode;
import com.ibm.ba.vis.vgs.error.ErrorMessage;
import com.ibm.cognos.rs.core.Status;
import com.ibm.cognos.rs.core.WebApplicationException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public class GalleryServiceException
extends WebApplicationException {
    private static final long serialVersionUID = 4493230665240311817L;
    private final List<ErrorMessage> errorList = new ArrayList<ErrorMessage>();

    public GalleryServiceException(ErrorCode errorCode) {
        this(new ErrorMessage(errorCode));
    }

    public GalleryServiceException(ErrorCode errorCode, Throwable t) {
        this(new ErrorMessage(errorCode), t);
    }

    public GalleryServiceException(ErrorMessage errorMessage) {
        super(errorMessage.getStatus());
        this.errorList.add(errorMessage);
    }

    public GalleryServiceException(ErrorMessage errorMessage, Throwable t) {
        super(t, errorMessage.getStatus());
        this.errorList.add(errorMessage);
    }

    public void addError(ErrorCode errorCode) {
        this.addError(new ErrorMessage(errorCode));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addError(ErrorMessage errorMessage) {
        List<ErrorMessage> list = this.errorList;
        synchronized (list) {
            this.errorList.add(errorMessage);
        }
    }

    @Override
    public Status getStatus() {
        return this.errorList.get(this.errorList.size() - 1).getStatus();
    }

    @Override
    public String getMessage() {
        return this.getLocalizedMessage();
    }

    @Override
    public String getLocalizedMessage() {
        return this.getLocalizedMessage(Locale.getDefault());
    }

    @Override
    public String getLocalizedMessage(Locale locale) {
        StringBuilder sb = new StringBuilder();
        for (int idx = this.errorList.size() - 1; idx >= 0; --idx) {
            ErrorMessage errorMessage = this.errorList.get(idx);
            sb.append(errorMessage.getLocalizedMessage(locale));
            if (idx == 0) continue;
            sb.append("\r\n");
        }
        return sb.toString();
    }

    public List<String> getAllMessages() {
        ArrayList<String> messages = new ArrayList<String>(this.errorList.size());
        for (ErrorMessage errorMessage : this.errorList) {
            messages.add(errorMessage.getLocalizedMessage(Locale.getDefault()));
        }
        Collections.reverse(messages);
        return messages;
    }
}

