/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.vis.vgs.gallery;

import com.ibm.ba.vis.schema.definition.Rave2BundleDefinitionManager;
import com.ibm.ba.vis.vgs.VgsApplicationModule;
import com.ibm.ba.vis.vgs.bundle.Image;
import com.ibm.ba.vis.vgs.bundle.MimeMap;
import com.ibm.ba.vis.vgs.bundle.VisBundle;
import com.ibm.ba.vis.vgs.bundle.VisResource;
import com.ibm.ba.vis.vgs.config.VGSConfiguration;
import com.ibm.ba.vis.vgs.error.ErrorMessage;
import com.ibm.ba.vis.vgs.error.GalleryAPIErrorCode;
import com.ibm.ba.vis.vgs.error.GalleryServiceErrorCode;
import com.ibm.ba.vis.vgs.error.GalleryServiceException;
import com.ibm.ba.vis.vgs.gallery.GalleryManager;
import com.ibm.ba.vis.vgs.gallery.GalleryResponder;
import com.ibm.ba.vis.vgs.gallery.Passport;
import com.ibm.ba.vis.vgs.gallery.RequestContextHelper;
import com.ibm.ba.vis.vgs.gallery.RequestContextHelperFactory;
import com.ibm.ba.vis.vgs.gallery.UpdateAction;
import com.ibm.ba.vis.vgs.gallery.XMLToJSON;
import com.ibm.ba.vis.vgs.gallery.cache.ResultPage;
import com.ibm.ba.vis.vgs.gallery.fs.FileSystemVisBundle;
import com.ibm.ba.vis.vgs.gallery.mem.InMemVisBundle;
import com.ibm.cognos.rs.Context;
import com.ibm.cognos.rs.DefaultValue;
import com.ibm.cognos.rs.Encoded;
import com.ibm.cognos.rs.GET;
import com.ibm.cognos.rs.HeaderParameter;
import com.ibm.cognos.rs.POST;
import com.ibm.cognos.rs.PUT;
import com.ibm.cognos.rs.Path;
import com.ibm.cognos.rs.PathParameter;
import com.ibm.cognos.rs.Produces;
import com.ibm.cognos.rs.QueryParameter;
import com.ibm.cognos.rs.core.RequestContext;
import com.ibm.cognos.rs.core.Response;
import com.ibm.cognos.rs.core.ResponseBuilder;
import com.ibm.cognos.rs.core.Status;
import com.ibm.cognos.rs.core.WebApplicationException;
import com.ibm.cognos.rs.core.utils.LogUtils;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.httpclient.HeaderElement;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.xml.sax.SAXException;

@Path(value="/gallery")
public class GalleryResource {
    private static final String FILE_SCHEME = "file";
    private static final String HTTP_SCHEME = "http";
    private static final String HTTPS_SCHEME = "https";
    private static final String RESPONSE_FORMAT_JSON = "json";
    private final GalleryManager manager;
    private final GalleryResponder responder;
    private final RequestContextHelper contextHelper;
    private final VGSConfiguration configuration;

    public GalleryResource(GalleryManager manager, GalleryResponder responder) {
        this(manager, responder, RequestContextHelperFactory.getInstance().get(), VGSConfiguration.getInstance());
    }

    GalleryResource(GalleryManager manager, GalleryResponder responder, RequestContextHelper contextHelper, VGSConfiguration configuration) {
        this.manager = manager;
        this.responder = responder;
        this.contextHelper = contextHelper;
        this.configuration = configuration;
    }

    @Path(value="")
    @GET
    public Response<?> list(@QueryParameter(value="si") @DefaultValue(value="0") int startIndex, @QueryParameter(value="ps") @DefaultValue(value="50") int pageSize, @QueryParameter(value="lang") @DefaultValue(value="en") String language, @QueryParameter(value="extraInfo") String extraInfo, @QueryParameter(value="fmt") String mediaType, @QueryParameter(value="category") String category, @Context RequestContext context) {
        Passport passport = this.contextHelper.getPassport(context);
        ResultPage<VisBundle> resultPage = this.manager.list(passport, startIndex, pageSize, language, false);
        InMemVisBundle.loadRave2BundlesInResultPage(resultPage, language, category);
        return this.createResponse(resultPage, language, extraInfo, mediaType, category, context);
    }

    @Path(value="rave1")
    @GET
    public Response<?> listRave1(@QueryParameter(value="si") @DefaultValue(value="0") int startIndex, @QueryParameter(value="ps") @DefaultValue(value="50") int pageSize, @QueryParameter(value="lang") @DefaultValue(value="en") String language, @QueryParameter(value="extraInfo") String extraInfo, @QueryParameter(value="fmt") String mediaType, @QueryParameter(value="category") String category, @Context RequestContext context) {
        Passport passport = this.contextHelper.getPassport(context);
        ResultPage<VisBundle> resultPage = this.manager.list(passport, startIndex, pageSize, language, false);
        return this.createResponse(resultPage, language, extraInfo, mediaType, category, context);
    }

    @Path(value="custom")
    @GET
    @Produces(value="application/json")
    public Response<?> listCustom(@QueryParameter(value="si") @DefaultValue(value="0") int startIndex, @QueryParameter(value="ps") @DefaultValue(value="50") int pageSize, @QueryParameter(value="lang") @DefaultValue(value="en") String language, @QueryParameter(value="category") String category, @Context RequestContext context) {
        Passport passport = this.contextHelper.getPassport(context);
        ResultPage<VisBundle> customBundles = this.manager.list(passport, startIndex, pageSize, language, true);
        List<VisBundle> filteredCustomBundles = category == null || category.isEmpty() ? customBundles : customBundles.stream().filter(bundle -> category.equals(bundle.getType())).collect(Collectors.toList());
        return this.listCustomBundlesResponse(filteredCustomBundles, language);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Response<?> listCustomBundlesResponse(List<VisBundle> filteredCustomBundles, String language) {
        JSONArray jsonResponse = new JSONArray();
        filteredCustomBundles.forEach(bundle -> {
            String description;
            JSONObject jsonBundle = new JSONObject();
            jsonBundle.put((Object)"id", (Object)bundle.getId());
            jsonBundle.put((Object)"name", (Object)bundle.getName(language));
            jsonBundle.put((Object)"type", (Object)bundle.getType());
            jsonBundle.put((Object)"storeId", (Object)bundle.getStoreId());
            String icon = bundle.getIcon();
            if (icon != null && !icon.isEmpty()) {
                jsonBundle.put((Object)"icon", (Object)icon);
            }
            if ((description = bundle.getDescription(language)) != null && !description.isEmpty()) {
                jsonBundle.put((Object)"description", (Object)description);
            }
            jsonBundle.put((Object)"modificationTime", (Object)bundle.getLastUpdatedAsString());
            jsonResponse.add((Object)jsonBundle);
        });
        try (InputStream responseStream = IOUtils.toInputStream((String)jsonResponse.toString(), (String)"UTF-8");){
            ResponseBuilder responseBuilder = this.getBaseOKResponseBuilder("", "application/json");
            Response<InputStream> response = responseBuilder.build(responseStream);
            return response;
        }
        catch (IOException e) {
            throw new GalleryServiceException(GalleryServiceErrorCode.internalServiceError, (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Response<?> listCustomBundleContentResponse(VisBundle bundle, List<String> customBundleFiles) {
        JSONArray jsonResponse = new JSONArray();
        customBundleFiles.forEach(file -> {
            JSONObject jsonFile = new JSONObject();
            jsonFile.put((Object)FILE_SCHEME, file);
            jsonResponse.add((Object)jsonFile);
        });
        try (InputStream responseStream = IOUtils.toInputStream((String)jsonResponse.toString(), (String)"UTF-8");){
            ResponseBuilder responseBuilder = this.getBaseOKResponseBuilder(bundle.getVersion(), "application/json");
            Response<InputStream> response = responseBuilder.build(responseStream);
            return response;
        }
        catch (IOException e) {
            throw new GalleryServiceException(GalleryServiceErrorCode.internalServiceError, (Throwable)e);
        }
    }

    @Path(value="rave2")
    @GET
    public Response<?> listRave2(@QueryParameter(value="si") @DefaultValue(value="0") int startIndex, @QueryParameter(value="ps") @DefaultValue(value="50") int pageSize, @QueryParameter(value="lang") @DefaultValue(value="en") String language, @QueryParameter(value="extraInfo") String extraInfo, @QueryParameter(value="fmt") String mediaType, @QueryParameter(value="category") String category, @Context RequestContext context) {
        ResultPage<VisBundle> resultPage = new ResultPage<VisBundle>(pageSize, startIndex);
        InMemVisBundle.loadRave2BundlesInResultPage(resultPage, language, category);
        return this.createResponse(resultPage, language, extraInfo, mediaType, category, context);
    }

    private Response<?> createResponse(ResultPage<VisBundle> resultPage, String language, String extraInfo, String mediaType, String category, RequestContext context) {
        String responseMediaType = "application/atom+xml";
        if (RESPONSE_FORMAT_JSON.equalsIgnoreCase(mediaType)) {
            responseMediaType = "application/json";
        }
        URI baseURI = this.getRequestPathURI(context);
        String timezoneID = this.getTimezoneID(context);
        return this.createAtomFeedResponse(language, baseURI, baseURI, timezoneID, extraInfo, resultPage, responseMediaType, category);
    }

    @Path(value="id/{visId:(?!-)(?:[a-zA-Z0-9\\-_,]+[.]?)+(?<![.])}")
    @GET
    public Response<?> findById(@PathParameter(value="visId") String visId, @QueryParameter(value="lang") @DefaultValue(value="en") String language, @HeaderParameter(value="If-None-Match") String requestedVersion, @QueryParameter(value="extraInfo") String extraInfo, @QueryParameter(value="category") String category, @QueryParameter(value="path") String path, @Context RequestContext context) {
        Response<?> response;
        Passport passport = this.contextHelper.getPassport(context);
        VisBundle bundle = null;
        if (Rave2BundleDefinitionManager.isRave2BundleName((String)visId)) {
            language = Rave2BundleDefinitionManager.updateLangName((String)language);
            bundle = InMemVisBundle.loadRave2BundleFromMemory(visId, language);
        } else {
            bundle = this.manager.get(passport, visId, language);
        }
        if (bundle instanceof FileSystemVisBundle && bundle.isCustomViz()) {
            if (path == null || path.isEmpty()) {
                return this.createCustomBundleContentResponse(bundle);
            }
            return this.createCustomBundleContentResponse(bundle, language, path);
        }
        if (bundle.getVersion().equals(requestedVersion)) {
            response = this.createNotModifiedResponse();
        } else {
            URI baseURI = this.getRequestPathURI(context);
            String timezoneID = this.getTimezoneID(context);
            response = this.createBundleEntryResponse(bundle, language, baseURI.resolve("../"), timezoneID, extraInfo, category);
        }
        return response;
    }

    private URI getRequestPathURI(RequestContext context) {
        StringBuilder sb = new StringBuilder(context.getScriptName());
        sb.append(context.getRequestURI().getPath());
        int end = sb.length() - 1;
        if ('/' == sb.charAt(end)) {
            sb.deleteCharAt(end);
        }
        return URI.create(sb.toString());
    }

    private Response<?> createBundleEntryResponse(VisBundle bundle, String language, URI requestURI, String timezoneID, String extraInfo, String category) {
        ResponseBuilder responseBuilder = this.getBaseOKResponseBuilder(bundle.getVersion(), "application/atom+xml");
        InputStream responseStream = this.responder.respond(requestURI, bundle, language, timezoneID, extraInfo, category);
        return responseBuilder.build(responseStream);
    }

    private Response<?> createCustomBundleContentResponse(VisBundle bundle) {
        try {
            List<String> bundleFiles = ((FileSystemVisBundle)bundle).getBundleFiles();
            return this.listCustomBundleContentResponse(bundle, bundleFiles);
        }
        catch (IOException e) {
            throw new GalleryServiceException(GalleryServiceErrorCode.internalServiceError, (Throwable)e);
        }
    }

    private Response<?> createCustomBundleContentResponse(VisBundle bundle, String language, String path) {
        InputStream responseStream = null;
        try {
            responseStream = ((FileSystemVisBundle)bundle).getBundleFileStream(path);
        }
        catch (IOException e) {
            throw new GalleryServiceException(GalleryServiceErrorCode.internalServiceError, (Throwable)e);
        }
        String ext = FilenameUtils.getExtension((String)path);
        String mimeType = MimeMap.get(ext);
        ResponseBuilder responseBuilder = this.getBaseOKResponseBuilder(bundle.getVersion(), mimeType);
        return responseBuilder.build(responseStream);
    }

    @Path(value="id/{visId:(?!-)(?:[a-zA-Z0-9\\-_,]+[.]?)+(?<![.])}/images/{imageId}")
    @GET
    public Response<?> getThumbnail(@PathParameter(value="visId") String visId, @PathParameter(value="imageId") String imageId, @HeaderParameter(value="If-None-Match") String requestedVersion, @Context RequestContext context) {
        Passport passport = this.contextHelper.getPassport(context);
        VisBundle bundle = this.manager.get(passport, visId, "en");
        Response<?> response = bundle.getVersion().equals(requestedVersion) ? this.createNotModifiedResponse() : this.createThumbnailResponse(bundle, imageId);
        return response;
    }

    private Response<?> createThumbnailResponse(VisBundle bundle, String imageId) {
        InputStream stream = null;
        try {
            Image image = bundle.getImage(imageId);
            if (image == null) {
                throw new GalleryServiceException(GalleryAPIErrorCode.resourceNotFound);
            }
            ResponseBuilder responseBuilder = this.getBaseOKResponseBuilder(bundle.getVersion(), image.getMimeType());
            stream = image.getImage();
            return responseBuilder.build(stream);
        }
        catch (IOException e) {
            IOUtils.closeQuietly(stream);
            throw new GalleryServiceException(GalleryServiceErrorCode.internalServiceError, (Throwable)e);
        }
    }

    @Path(value="id/{visId:(?!-)(?:[a-zA-Z0-9\\-_,]+[.]?)+(?<![.])}/definition")
    @GET
    public Response<?> getDefinition(@PathParameter(value="visId") String visId, @QueryParameter(value="lang") @DefaultValue(value="en") String language, @HeaderParameter(value="If-None-Match") String requestedVersion, @Encoded @HeaderParameter(value="Accept") @DefaultValue(value="*/*") String acceptHeader, @Context RequestContext context) {
        Response<?> response;
        Passport passport = this.contextHelper.getPassport(context);
        VisBundle bundle = null;
        if (Rave2BundleDefinitionManager.isRave2BundleName((String)visId)) {
            language = Rave2BundleDefinitionManager.updateLangName((String)language);
            bundle = InMemVisBundle.loadRave2BundleFromMemory(visId, language);
        } else {
            bundle = this.manager.get(passport, visId, language);
        }
        if (bundle.getVersion().equals(requestedVersion)) {
            response = this.createNotModifiedResponse();
        } else {
            String definitionVersion = this.parseAcceptHeader(acceptHeader);
            response = this.createDefinitionResponse(bundle, language, definitionVersion);
        }
        return response;
    }

    private String parseAcceptHeader(String acceptHeader) {
        HeaderElement[] elements;
        Double v1Value = null;
        Double v2Value = null;
        Double v3Value = null;
        Double v3_1Value = null;
        for (HeaderElement element : elements = HeaderElement.parseElements((String)acceptHeader)) {
            String name = element.getName();
            if (!name.startsWith("application/vnd.vis.ibm.com.definition")) continue;
            if ("application/vnd.vis.ibm.com.definition.1+xml".equals(name)) {
                v1Value = this.getQualityValue(element);
                continue;
            }
            if ("application/vnd.vis.ibm.com.definition.2+xml".equals(name)) {
                v2Value = this.getQualityValue(element);
                continue;
            }
            if ("application/vnd.vis.ibm.com.definition.3+xml".equals(name)) {
                v3Value = this.getQualityValue(element);
                continue;
            }
            if ("application/vnd.vis.ibm.com.definition.3_1+xml".equals(name)) {
                v3_1Value = this.getQualityValue(element);
                continue;
            }
            ErrorMessage message = new ErrorMessage(GalleryAPIErrorCode.unsupportedUpgrade);
            message.addParameter("definitionVersion", name);
            throw new GalleryServiceException(message);
        }
        return this.determinePreferedVersion(v1Value, v2Value, v3Value, v3_1Value);
    }

    private String determinePreferedVersion(Double v1Value, Double v2Value, Double v3Value, Double v3_1Value) {
        String version = "*/*";
        if (v3Value != null || v3_1Value != null) {
            version = v2Value != null ? (v2Value > v3Value ? "application/vnd.vis.ibm.com.definition.2+xml" : "application/vnd.vis.ibm.com.definition.3_1+xml") : "application/vnd.vis.ibm.com.definition.3_1+xml";
        } else if (v2Value != null) {
            version = v1Value != null ? (v1Value > v2Value ? "application/vnd.vis.ibm.com.definition.1+xml" : "application/vnd.vis.ibm.com.definition.2+xml") : "application/vnd.vis.ibm.com.definition.2+xml";
        } else if (v1Value != null) {
            version = "application/vnd.vis.ibm.com.definition.1+xml";
        }
        return version;
    }

    private Double getQualityValue(HeaderElement element) {
        NameValuePair quality = element.getParameterByName("q");
        Double value = quality != null ? Double.valueOf(quality.getValue()) : Double.valueOf(1.0);
        return value;
    }

    private Response<?> createDefinitionResponse(VisBundle bundle, String language, String definitionVersion) {
        InputStream stream = null;
        try {
            ResponseBuilder responseBuilder = this.getBaseOKResponseBuilder(bundle.getVersion(), definitionVersion + "; charset=\"utf-8\"");
            responseBuilder.header("Vary", "Accept");
            stream = bundle.getDefinition(language, definitionVersion);
            return responseBuilder.build(stream);
        }
        catch (IOException e) {
            IOUtils.closeQuietly(stream);
            throw new GalleryServiceException(GalleryServiceErrorCode.internalServiceError, (Throwable)e);
        }
    }

    @Path(value="id/{visId:(?!-)(?:[a-zA-Z0-9\\-_,]+[.]?)+(?<![.])}/implementation")
    @GET
    public Response<?> getImplementation(@PathParameter(value="visId") String visId, @QueryParameter(value="fmt") @DefaultValue(value="json") String format, @HeaderParameter(value="If-None-Match") String requestedVersion, @Context RequestContext context) {
        Passport passport = this.contextHelper.getPassport(context);
        VisBundle bundle = this.manager.get(passport, visId, "en");
        List<String> formats = bundle.getImplementationFormats();
        if (!formats.contains(format)) {
            throw new GalleryServiceException(GalleryAPIErrorCode.resourceNotFound);
        }
        Response<?> response = bundle.getVersion().equals(requestedVersion) ? this.createNotModifiedResponse() : this.createImplementationResponse(bundle, format);
        return response;
    }

    private Response<?> createImplementationResponse(VisBundle bundle, String format) {
        InputStream stream = null;
        try {
            ResponseBuilder responseBuilder = this.getBaseOKResponseBuilder(bundle.getVersion(), MimeMap.get(format));
            stream = bundle.getImplementation(format);
            return responseBuilder.build(stream);
        }
        catch (IOException e) {
            IOUtils.closeQuietly(stream);
            throw new GalleryServiceException(GalleryServiceErrorCode.internalServiceError, (Throwable)e);
        }
    }

    private ResponseBuilder getBaseOKResponseBuilder(String etag, String mimeType) {
        ResponseBuilder responseBuilder = ResponseBuilder.newInstance();
        responseBuilder.type(mimeType);
        responseBuilder.status(Status.OK);
        responseBuilder.header("Etag", etag);
        responseBuilder.lastModified(new Date());
        return responseBuilder;
    }

    private Response<?> createNotModifiedResponse() {
        ResponseBuilder responseBuilder = ResponseBuilder.newInstance();
        responseBuilder.status(Status.NOT_MODIFIED);
        return responseBuilder.build();
    }

    @Path(value="id/{visId:(?!-)(?:[a-zA-Z0-9\\-_,]+[.]?)+(?<![.])}/adapter")
    @GET
    @Produces(value="text/plain")
    public String getAdapter(@PathParameter(value="visId") String visId, @Context RequestContext context) {
        Passport passport = this.contextHelper.getPassport(context);
        VisBundle bundle = this.manager.get(passport, visId, "en");
        return bundle.getAdapter();
    }

    @Path(value="id/{visId:(?!-)(?:[a-zA-Z0-9\\-_,]+[.]?)+(?<![.])}/content")
    @GET
    @Produces(value="application/zip")
    public Response<?> getContent(@PathParameter(value="visId") String visId, @HeaderParameter(value="If-None-Match") String requestedVersion, @Context RequestContext context) {
        Response<?> response;
        Passport passport = this.contextHelper.getPassport(context);
        VisBundle bundle = this.manager.get(passport, visId, "en");
        String currentVersion = bundle.getVersion();
        if (currentVersion.equals(requestedVersion)) {
            response = this.createNotModifiedResponse();
        } else {
            URI contentURI = bundle.getContentURI();
            this.validateContentURI(contentURI);
            response = FILE_SCHEME.equals(contentURI.getScheme()) ? this.createLocalContentResponse(contentURI, bundle) : this.createRemoteContentResponse(contentURI, context.getScriptName());
        }
        return response;
    }

    private void validateContentURI(URI contentURI) {
        boolean isInvalid = true;
        if (StringUtils.isNotEmpty((String)contentURI.getPath())) {
            String scheme = contentURI.getScheme();
            isInvalid &= !FILE_SCHEME.equals(scheme);
            isInvalid &= !HTTP_SCHEME.equals(scheme);
            isInvalid &= !HTTPS_SCHEME.equals(scheme);
            isInvalid &= StringUtils.isNotEmpty((String)scheme);
        }
        if (isInvalid) {
            throw new GalleryServiceException(GalleryAPIErrorCode.resourceNotFound);
        }
    }

    private Response<?> createLocalContentResponse(URI contentURI, VisBundle bundle) {
        FileInputStream contentStream = null;
        try {
            File contentFile = new File(contentURI);
            contentStream = FileUtils.openInputStream((File)contentFile);
        }
        catch (IOException e) {
            IOUtils.closeQuietly(contentStream);
            throw new GalleryServiceException(GalleryServiceErrorCode.internalServiceError, (Throwable)e);
        }
        ResponseBuilder responseBuilder = this.getBaseOKResponseBuilder(bundle.getVersion(), "application/zip");
        responseBuilder.header("Content-Disposition", "attachment;  filename=" + bundle.getId() + ".zip;");
        return responseBuilder.build(contentStream);
    }

    private Response<?> createAtomFeedResponse(String language, URI baseURI, URI entryBaseURI, String timezoneID, String extraInfo, ResultPage<? extends VisResource> resultPage, String mediaType, String category) {
        ResponseBuilder responseBuilder = ResponseBuilder.newInstance();
        responseBuilder.type(mediaType);
        responseBuilder.status(Status.OK);
        responseBuilder.header("Cache-Control", "no-cache");
        InputStream responseStream = this.responder.respond(baseURI, entryBaseURI, resultPage, language, timezoneID, extraInfo, category);
        if ("application/json".equalsIgnoreCase(mediaType)) {
            try {
                String uft8String = IOUtils.toString((InputStream)responseStream, (String)"UTF-8");
                responseStream = IOUtils.toInputStream((String)XMLToJSON.convertXMLToJSON(uft8String, "UTF-8"));
            }
            catch (SAXException e) {
                throw new GalleryServiceException(GalleryServiceErrorCode.internalServiceError, (Throwable)e);
            }
            catch (IOException e) {
                throw new GalleryServiceException(GalleryServiceErrorCode.internalServiceError, (Throwable)e);
            }
            catch (Exception e) {
                throw new GalleryServiceException(GalleryServiceErrorCode.internalServiceError, (Throwable)e);
            }
        }
        return responseBuilder.build(responseStream);
    }

    private Response<?> createRemoteContentResponse(URI contentURI, String scriptName) {
        URI redirectURI;
        ResponseBuilder responseBuilder = ResponseBuilder.newInstance();
        responseBuilder.status(Status.FOUND);
        if (StringUtils.isEmpty((String)contentURI.getScheme())) {
            URI scriptURI = URI.create(scriptName + "/");
            redirectURI = scriptURI.resolve(contentURI);
        } else {
            redirectURI = contentURI;
        }
        responseBuilder.header("Location", redirectURI.toString());
        return responseBuilder.build();
    }

    @Path(value="")
    @POST
    public Response<?> storeBundle(@Context RequestContext context, @QueryParameter(value="updateAction") @DefaultValue(value="UPDATE") UpdateAction updateAction, @QueryParameter(value="maskResponses") @DefaultValue(value="false") boolean maskResponses) {
        Response<?> response;
        try {
            response = this.handleStoreRequest(context, updateAction);
        }
        catch (RuntimeException e) {
            if (maskResponses) {
                response = this.getMaskedErrorResponse(e);
            }
            throw e;
        }
        return response;
    }

    @Path(value="id/{visId:(?!-)(?:[a-zA-Z0-9\\-_,]+[.]?)+(?<![.])}")
    @PUT
    public Response<?> updateBundle(@Context RequestContext context, @PathParameter(value="visId") String visId, @QueryParameter(value="lang") @DefaultValue(value="en") String language) {
        Passport passport = this.contextHelper.getPassport(context);
        VisBundle bundle = this.manager.get(passport, visId, language);
        Response<?> response = null;
        ErrorMessage errorMessage = new ErrorMessage(GalleryAPIErrorCode.invalidBundleId);
        errorMessage.addParameter("bundleId", visId);
        if (!visId.equals(bundle.getId())) {
            throw new GalleryServiceException(errorMessage);
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)context.getRequestBodyStream(), (OutputStream)baos);
            byte[] bodyBytes = baos.toByteArray();
            if (!this.validateBundle(visId, bodyBytes)) {
                throw new GalleryServiceException(errorMessage);
            }
            response = this.handleUpdateRequest(context, bodyBytes);
        }
        catch (IOException | RuntimeException e) {
            response = this.getMaskedErrorResponse(e);
        }
        return response;
    }

    private boolean validateBundle(String visId, byte[] bodyBytes) {
        ByteArrayInputStream bais = new ByteArrayInputStream(bodyBytes);
        ZipInputStream bodyZIP = new ZipInputStream((InputStream)bais, Charsets.UTF_8);
        try {
            ZipEntry entry;
            while ((entry = bodyZIP.getNextEntry()) != null) {
                if (entry.isDirectory() || !"meta.json".equals(entry.getName())) continue;
                String metaStr = IOUtils.toString((InputStream)bodyZIP, (String)"UTF-8");
                JSONObject metaJson = JSONObject.parse((String)metaStr);
                String id = metaJson.get((Object)"id").toString();
                if (visId.equals(id)) break;
                return false;
            }
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    private Response<?> handleUpdateRequest(RequestContext context, byte[] bodyBytes) {
        this.contextHelper.validateXsrfToken(context);
        Passport passport = this.contextHelper.getPassport(context);
        ByteArrayInputStream bais = new ByteArrayInputStream(bodyBytes);
        String visId = this.storeContent(bais, passport, UpdateAction.UPDATE);
        ResponseBuilder responseBuilder = ResponseBuilder.newInstance();
        StringBuilder resourcePath = new StringBuilder();
        resourcePath.append(context.getRequestURL());
        LinkedHashMap<String, String> props = new LinkedHashMap<String, String>(2, 1.0f);
        props.put("Message", Status.OK.getReasonPhrase());
        props.put("Location", resourcePath.toString());
        InputStream responseStream = this.buildJsonRequestResponse(Status.OK.getStatusCode(), props);
        responseBuilder.status(Status.OK);
        return responseBuilder.build(responseStream);
    }

    private Response<?> handleStoreRequest(RequestContext context, UpdateAction updateAction) {
        this.contextHelper.validateXsrfToken(context);
        Passport passport = this.contextHelper.getPassport(context);
        String visId = this.storeContent(context.getRequestBodyStream(), passport, updateAction);
        ResponseBuilder responseBuilder = ResponseBuilder.newInstance();
        StringBuilder resourcePath = new StringBuilder();
        resourcePath.append(context.getRequestURL()).append('/');
        resourcePath.append("id").append('/').append(visId);
        LinkedHashMap<String, String> props = new LinkedHashMap<String, String>(2, 1.0f);
        props.put("Message", Status.CREATED.getReasonPhrase());
        props.put("Location", resourcePath.toString());
        InputStream responseStream = this.buildJsonRequestResponse(Status.CREATED.getStatusCode(), props);
        responseBuilder.status(Status.OK);
        return responseBuilder.build(responseStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String storeContent(InputStream requestStream, Passport passport, UpdateAction updateAction) {
        try {
            String string = this.manager.store(passport, requestStream, updateAction);
            return string;
        }
        finally {
            IOUtils.closeQuietly((InputStream)requestStream);
        }
    }

    private Response<?> getMaskedErrorResponse(Exception e) {
        Status status;
        this.logMaskedException(e);
        ResponseBuilder responseBuilder = ResponseBuilder.newInstance();
        responseBuilder.status(Status.OK);
        String statusMsg = e.getMessage();
        if (e instanceof WebApplicationException) {
            WebApplicationException we = (WebApplicationException)e;
            status = we.getStatus();
        } else {
            status = Status.INTERNAL_SERVER_ERROR;
        }
        LinkedHashMap<String, String> props = new LinkedHashMap<String, String>(1, 1.0f);
        props.put("Message", status.getReasonPhrase());
        props.put("Description", statusMsg);
        InputStream stream = this.buildJsonRequestResponse(status.getStatusCode(), props);
        return responseBuilder.build(stream);
    }

    private void logMaskedException(Exception e) {
        if (e instanceof WebApplicationException) {
            LogUtils.logWebApplicationException((WebApplicationException)e, this.getLog());
        } else {
            this.getLog().error((Object)e);
        }
    }

    private InputStream buildJsonRequestResponse(int statusCode, Map<String, String> props) {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        sb.append("\"Status\": ");
        sb.append(statusCode).append(',');
        for (Map.Entry<String, String> entry : props.entrySet()) {
            sb.append('\"').append(entry.getKey()).append("\": ");
            String value = entry.getValue();
            value = value.replaceAll("[\\r]?[\\n]", "\\\\n");
            value = value.replaceAll("[\\\"]", "&quot;");
            sb.append('\"').append(value).append('\"').append(',');
        }
        if (props.size() > 0) {
            sb.delete(sb.length() - 1, sb.length());
        }
        sb.append('}');
        return new ByteArrayInputStream(sb.toString().getBytes());
    }

    private Log getLog() {
        return VgsApplicationModule.getModuleLog();
    }

    private String getTimezoneID(RequestContext context) {
        String tzID = context.getTimezoneID();
        if (StringUtils.isBlank((String)tzID)) {
            tzID = this.configuration.getValue("serverTimeZoneID");
        }
        return tzID;
    }
}

