/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.vis.vgs.gallery;

import com.ctc.wstx.stax.WstxEventFactory;
import com.ctc.wstx.stax.WstxInputFactory;
import com.ctc.wstx.stax.WstxOutputFactory;
import com.ibm.ba.vis.schema.definition.DefinitionUpgrader;
import com.ibm.ba.vis.schema.definition.DefinitionValidatorFactory;
import com.ibm.ba.vis.vgs.atom.AtomResponder;
import com.ibm.ba.vis.vgs.bundle.DefinitionManager;
import com.ibm.ba.vis.vgs.gallery.GalleryManager;
import com.ibm.ba.vis.vgs.gallery.GalleryResource;
import com.ibm.ba.vis.vgs.parser.DefinitionParser;
import com.ibm.ba.vis.vgs.resources.ResourceManagerFactory;
import com.ibm.cognos.rs.core.ResourceProvider;
import java.lang.reflect.Constructor;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;

public class GalleryResourceProvider
implements ResourceProvider<GalleryResource> {
    static final String GALLERY_MANAGER = "com.ibm.ba.vis.vgs.gallery.manager";
    static final String DEFAULT_GALERRY_MANAGER = "com.ibm.ba.vis.vgs.gallery.cm.CMGalleryManager";
    private static final GalleryResource INSTANCE;

    private static XMLInputFactory createXMLInputFactory() {
        WstxInputFactory inputFactory = new WstxInputFactory();
        inputFactory.setProperty("javax.xml.stream.isReplacingEntityReferences", false);
        inputFactory.setProperty("javax.xml.stream.resolver", new XMLResolver(){

            @Override
            public Object resolveEntity(String publicID, String systemID, String baseURI, String namespace) throws XMLStreamException {
                throw new XMLStreamException("Access to denied to publicID=" + publicID + ", systemID=" + systemID + ".");
            }
        });
        return inputFactory;
    }

    @Override
    public Class<GalleryResource> getProvidedClass() {
        return GalleryResource.class;
    }

    @Override
    public GalleryResource provide() {
        return INSTANCE;
    }

    static {
        try {
            String galleryManagerClassNAme = System.getProperty(GALLERY_MANAGER, DEFAULT_GALERRY_MANAGER);
            ClassLoader classLoader = GalleryResourceProvider.class.getClassLoader();
            Class<?> galleryManagerClass = classLoader.loadClass(galleryManagerClassNAme);
            Constructor<?> constructor = galleryManagerClass.getConstructor(DefinitionManager.class, ResourceManagerFactory.class);
            WstxOutputFactory outputFactory = new WstxOutputFactory();
            WstxEventFactory eventFactory = new WstxEventFactory();
            DefinitionParser parser = new DefinitionParser(GalleryResourceProvider.createXMLInputFactory(), (XMLOutputFactory)outputFactory, (XMLEventFactory)eventFactory);
            DefinitionUpgrader upgrader = new DefinitionUpgrader();
            DefinitionManager definitionManager = new DefinitionManager(parser, DefinitionValidatorFactory.getInstance(), upgrader);
            GalleryManager manager = (GalleryManager)constructor.newInstance(definitionManager, ResourceManagerFactory.instance());
            AtomResponder responder = new AtomResponder();
            INSTANCE = new GalleryResource(manager, responder);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

