/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.vis.vgs.gallery;

import com.ibm.ba.vis.vgs.gallery.RequestContextHelper;
import java.lang.reflect.Constructor;

public class RequestContextHelperFactory {
    static final String CONTEXT_HELPER = "com.ibm.ba.vis.vgs.gallery.contexthelper";
    static final String DEFAULT_CONTEXT_HELPER = "com.ibm.ba.vis.vgs.p2pd.PogoContextHelper";
    private static final RequestContextHelperFactory INSTANCE = new RequestContextHelperFactory();
    private final Class<? extends RequestContextHelper> contextHelperClass;

    RequestContextHelperFactory() {
        this(System.getProperty(CONTEXT_HELPER, DEFAULT_CONTEXT_HELPER));
    }

    RequestContextHelperFactory(String contextHelperClassName) {
        try {
            ClassLoader classLoader = this.getClass().getClassLoader();
            this.contextHelperClass = classLoader.loadClass(contextHelperClassName);
            Constructor<? extends RequestContextHelper> constructor = this.contextHelperClass.getConstructor(new Class[0]);
            if (constructor == null) {
                throw new IllegalArgumentException(contextHelperClassName + " does not have a no parameter public constructor");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public RequestContextHelper get() {
        try {
            return this.contextHelperClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static RequestContextHelperFactory getInstance() {
        return INSTANCE;
    }
}

