/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.vis.vgs.gallery.cache;

import com.ibm.ba.vis.vgs.bundle.VisBundle;
import java.util.Map;
import org.apache.commons.collections.map.LRUMap;

public class BundleCache {
    private static final int MAX_SIZE = 100;
    private static final BundleCache INSTANCE = new BundleCache();
    private final Map<String, VisBundle> bundleCache = new LRUMap(100);

    BundleCache() {
    }

    public synchronized void put(VisBundle bundle, String eTag) {
        String key = this.createKey(bundle.getId(), eTag);
        this.bundleCache.put(key, bundle);
    }

    public VisBundle get(String visId, String eTag) {
        String key = this.createKey(visId, eTag);
        return this.bundleCache.get(key);
    }

    public void clear() {
        this.bundleCache.clear();
    }

    private String createKey(String visId, String eTag) {
        return visId + "_" + eTag;
    }

    public static final BundleCache getInstance() {
        return INSTANCE;
    }
}

