/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.vis.vgs.gallery.cache;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public final class CompressionUtil {
    private static final String DEFAULT_BASE_PATH = "";
    private static final String PATH_SEPARATOR = "/";
    private static final Pattern RELATIVE_PATH_PATTERN = Pattern.compile("[.][.][/\\\\]");

    private CompressionUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void uncompress(File src, File destDir) throws IOException {
        if (!destDir.exists()) {
            destDir.mkdir();
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(src);
            ZipInputStream zis = new ZipInputStream(fis);
            CompressionUtil.uncompress(zis, destDir);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fis);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)fis);
    }

    public static void uncompress(ZipInputStream zis, File destDir) throws IOException {
        try {
            ZipEntry entry = zis.getNextEntry();
            while (entry != null) {
                if (entry.isDirectory()) {
                    CompressionUtil.createDirectory(destDir, entry);
                } else {
                    CompressionUtil.decompressFileEntry(zis, destDir, entry);
                }
                entry = zis.getNextEntry();
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)zis);
        }
    }

    private static void createDirectory(File destDir, ZipEntry entry) {
        String entryName = entry.getName();
        if (CompressionUtil.isValidEntryName(entryName)) {
            File entryFile = new File(destDir, entryName);
            entryFile.mkdirs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void decompressFileEntry(ZipInputStream zis, File destDir, ZipEntry entry) throws IOException {
        String entryName = entry.getName();
        if (CompressionUtil.isValidEntryName(entryName)) {
            File entryFile = new File(destDir, entryName);
            FileUtils.touch((File)entryFile);
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(entryFile);
                IOUtils.copyLarge((InputStream)zis, (OutputStream)fos, (long)0L, (long)entry.getSize());
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fos);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)fos);
        }
    }

    private static boolean isValidEntryName(String entryName) {
        Matcher relativePathMatcher = RELATIVE_PATH_PATTERN.matcher(entryName);
        return !relativePathMatcher.find();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void compress(File source, File destination) throws IOException {
        ZipOutputStream zipStream;
        block3: {
            zipStream = null;
            try {
                zipStream = new ZipOutputStream(new FileOutputStream(destination));
                if (source.isDirectory()) {
                    File[] contents = source.listFiles();
                    CompressionUtil.addContent(DEFAULT_BASE_PATH, zipStream, contents);
                    break block3;
                }
                CompressionUtil.addFileEntry(DEFAULT_BASE_PATH, zipStream, source);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(zipStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)zipStream);
    }

    private static void addContent(String basePath, ZipOutputStream zipStream, File[] contents) throws IOException {
        if (contents != null) {
            for (File file : contents) {
                if (file.isDirectory()) {
                    CompressionUtil.addDirectoryEntry(basePath, zipStream, file);
                    continue;
                }
                CompressionUtil.addFileEntry(basePath, zipStream, file);
            }
        }
    }

    private static void addDirectoryEntry(String basePath, ZipOutputStream zipStream, File file) throws IOException {
        String path = basePath + file.getName() + PATH_SEPARATOR;
        zipStream.putNextEntry(new ZipEntry(path));
        zipStream.closeEntry();
        CompressionUtil.addContent(path, zipStream, file.listFiles());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addFileEntry(String basePath, ZipOutputStream zipStream, File file) throws IOException {
        FileInputStream is = null;
        try {
            zipStream.putNextEntry(new ZipEntry(basePath + file.getName()));
            is = FileUtils.openInputStream((File)file);
            IOUtils.copy((InputStream)is, (OutputStream)zipStream);
            zipStream.closeEntry();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(is);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)is);
    }
}

