/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.vis.vgs.gallery.cache;

import java.util.Map;
import org.apache.commons.collections.map.LRUMap;

public class LRUCache<T> {
    private static final int DEFAULT_SIZE = 100;
    private final Map<String, T> objectCache;

    LRUCache(int size) {
        this.objectCache = new LRUMap(size);
    }

    public synchronized T put(String key, T value) {
        return this.objectCache.put(key, value);
    }

    public T get(String key) {
        return this.objectCache.get(key);
    }

    public boolean contains(String key) {
        return this.objectCache.containsKey(key);
    }

    public void clear() {
        this.objectCache.clear();
    }

    public static final <V> LRUCache<V> newInstance() {
        return new LRUCache(100);
    }

    public static final <V> LRUCache<V> newInstance(int size) {
        return new LRUCache(size);
    }
}

