/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.vis.vgs.gallery.cache;

import com.ibm.ba.vis.schema.definition.Rave2DefinitionConverter;
import com.ibm.ba.vis.vgs.VgsApplicationModule;
import com.ibm.ba.vis.vgs.config.VGSConfiguration;
import com.ibm.ba.vis.vgs.error.GalleryServiceErrorCode;
import com.ibm.ba.vis.vgs.error.GalleryServiceException;
import com.ibm.ba.vis.vgs.gallery.cache.CacheManager;
import com.ibm.ba.vis.vgs.gallery.cache.CompressionUtil;
import com.ibm.ba.vis.vgs.gallery.cache.FileStartsWithFilter;
import com.ibm.ba.vis.vgs.gallery.cache.ResultPage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;

public class LocalCacheManager
implements CacheManager {
    private static final String CACHE_FOLDER_NAME = "cache";
    private static LocalCacheManager instance;
    private final VGSConfiguration config;
    private final Map<String, String> eTagMap;
    private final Map<String, ReadWriteLock> cacheLocks;
    private final SortedSet<String> bundleIds;
    private volatile File cacheTempFolder;

    LocalCacheManager() {
        this(VGSConfiguration.getInstance());
    }

    LocalCacheManager(VGSConfiguration config) {
        this.config = config;
        this.eTagMap = new HashMap<String, String>();
        this.cacheLocks = new HashMap<String, ReadWriteLock>();
        this.bundleIds = new TreeSet<String>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getETag(String visId) {
        String etag = null;
        Lock readLock = this.getReadLock(visId);
        if (readLock != null) {
            readLock.lock();
            try {
                etag = this.eTagMap.get(visId);
            }
            finally {
                readLock.unlock();
            }
        }
        return etag;
    }

    @Override
    public List<File> list(int startIndex, int pageSize) throws IOException {
        String visId;
        File bundle;
        this.checkAccess(this.getTempFolder());
        ResultPage<File> bundles = new ResultPage<File>(pageSize, startIndex);
        Iterator iterator = this.bundleIds.iterator();
        while (iterator.hasNext() && bundles.add(bundle = this.get(visId = (String)iterator.next()))) {
        }
        return bundles;
    }

    @Override
    public File get(String visId) throws IOException {
        this.checkAccess(this.getTempFolder());
        File bundleFolder = null;
        String etag = this.getETag(visId);
        if (etag != null) {
            bundleFolder = this.getBundleFolder(visId, etag);
        }
        return bundleFolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void store(String visId, String etag, InputStream contentStream) throws IOException {
        this.checkAccess(this.getTempFolder());
        Lock writeLock = this.getWriteLock(visId);
        writeLock.lock();
        try {
            if (this.isNewOrUncached(visId, etag)) {
                String newEtag = this.validateEtag(etag);
                ZipInputStream zis = this.getCompressedStream(contentStream);
                File bundleFolder = this.getBundleFolder(visId, newEtag);
                CompressionUtil.uncompress(zis, bundleFolder);
                this.updateRave2Bundle(bundleFolder);
                this.putEtag(visId, newEtag);
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)contentStream);
            writeLock.unlock();
        }
    }

    private void updateRave2Bundle(File bundleFolder) throws IOException {
        String rave2BundleName = this.getRave2bundleName(bundleFolder);
        if (rave2BundleName != null) {
            this.generateRave2BundleDefinition(bundleFolder, rave2BundleName);
        }
    }

    private void generateRave2BundleDefinition(File bundleFolder, String rave2BundleName) throws IOException {
        Rave2DefinitionConverter converter = new Rave2DefinitionConverter("en");
        InputStream definitionStreamIn = converter.convert(rave2BundleName);
        File targetFile = new File(bundleFolder.getAbsolutePath() + "/" + "definition.xml");
        FileOutputStream definitionStreamOut = new FileOutputStream(targetFile);
        IOUtils.copy((InputStream)definitionStreamIn, (OutputStream)definitionStreamOut);
        definitionStreamIn.close();
        ((OutputStream)definitionStreamOut).close();
    }

    private String getRave2bundleName(File bundleFolder) {
        String bundleName = null;
        if (bundleFolder != null && bundleFolder.listFiles() != null && bundleFolder.listFiles().length == 1 && bundleFolder.listFiles()[0].isDirectory() && bundleFolder.listFiles()[0].getName().startsWith("rave-library")) {
            bundleName = bundleFolder.listFiles()[0].getName();
        }
        return bundleName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(String visID) throws IOException {
        if (this.getETag(visID) != null) {
            Lock writeLock = this.getWriteLock(visID);
            writeLock.lock();
            try {
                File tempFolder = this.getTempFolder();
                File[] visVersions = tempFolder.listFiles(new FileStartsWithFilter(visID));
                if (visVersions != null) {
                    for (File version : visVersions) {
                        FileUtils.deleteQuietly((File)version);
                    }
                }
            }
            finally {
                this.removeFromInternalCache(visID);
                writeLock.unlock();
            }
        }
    }

    @Override
    public void removeQuietly(String visID) {
        if (visID != null) {
            try {
                this.remove(visID);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private synchronized void removeFromInternalCache(String visID) {
        this.eTagMap.remove(visID);
        this.cacheLocks.remove(visID);
        this.bundleIds.remove(visID);
    }

    @Override
    public synchronized void clear() {
        this.clearAll();
        try {
            FileUtils.forceDelete((File)this.getTempFolder());
        }
        catch (IOException e) {
            GalleryServiceException gse = new GalleryServiceException(GalleryServiceErrorCode.failedToClearLocalCache, (Throwable)e);
            this.getLog().error((Object)gse);
        }
    }

    private String validateEtag(String etag) {
        String newEtag = etag;
        if (StringUtils.isEmpty((String)newEtag)) {
            newEtag = StringUtils.remove((String)UUID.randomUUID().toString(), (char)'-');
        }
        return newEtag;
    }

    private Lock getReadLock(String visId) {
        ReadWriteLock readWriteLock = this.cacheLocks.get(visId);
        if (readWriteLock != null) {
            return readWriteLock.readLock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Lock getWriteLock(String visId) {
        ReadWriteLock readWriteLock = this.cacheLocks.get(visId);
        if (readWriteLock == null) {
            Map<String, ReadWriteLock> map = this.cacheLocks;
            synchronized (map) {
                readWriteLock = this.cacheLocks.get(visId);
                if (readWriteLock == null) {
                    readWriteLock = new ReentrantReadWriteLock();
                    this.cacheLocks.put(visId, readWriteLock);
                    this.bundleIds.add(visId);
                }
            }
        }
        return readWriteLock.writeLock();
    }

    private ZipInputStream getCompressedStream(InputStream contentStream) {
        ZipInputStream zis = contentStream instanceof ZipInputStream ? (ZipInputStream)contentStream : new ZipInputStream(contentStream);
        return zis;
    }

    private boolean isNewOrUncached(String visId, String etag) throws IOException {
        String oldEtag = this.getETag(visId);
        boolean isNew = StringUtils.isEmpty((String)oldEtag) || !this.getBundleFolder(visId, oldEtag).exists();
        return isNew || !StringUtils.isEmpty((String)visId) && !oldEtag.equals(etag);
    }

    private File getBundleFolder(String visId, String etag) throws IOException {
        String bundleName = visId + "_" + etag.replace('=', '.');
        return new File(this.getTempFolder(), bundleName);
    }

    private File getTempFolder() throws IOException {
        if (this.config.getTempFolder() == null) {
            throw new IOException("No local cache location has been configured");
        }
        File newTempFolder = new File(this.config.getTempFolder(), CACHE_FOLDER_NAME);
        if (!newTempFolder.equals(this.cacheTempFolder)) {
            this.cacheTempFolder = newTempFolder;
            this.clearAll();
        }
        if (!this.cacheTempFolder.exists()) {
            this.createCacheTempFolder();
        }
        return this.cacheTempFolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createCacheTempFolder() {
        try {
            File file = this.cacheTempFolder;
            synchronized (file) {
                if (!this.cacheTempFolder.exists()) {
                    this.cacheTempFolder.mkdirs();
                }
            }
        }
        catch (SecurityException se) {
            throw new GalleryServiceException(GalleryServiceErrorCode.failedToAccessLocalCache, (Throwable)se);
        }
    }

    private synchronized void clearAll() {
        this.eTagMap.clear();
        this.cacheLocks.clear();
        this.bundleIds.clear();
    }

    private void checkAccess(File file) {
        if (file == null || !file.canWrite()) {
            throw new GalleryServiceException(GalleryServiceErrorCode.failedToAccessLocalCache);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putEtag(String visId, String etag) {
        if (etag != null) {
            Map<String, String> map = this.eTagMap;
            synchronized (map) {
                this.eTagMap.put(visId, etag);
            }
        }
    }

    private Log getLog() {
        return VgsApplicationModule.getModuleLog();
    }

    public static synchronized LocalCacheManager getInstance() {
        if (instance == null) {
            instance = new LocalCacheManager();
        }
        return instance;
    }
}

