/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.vis.vgs.gallery.cache;

import java.util.ArrayList;
import java.util.Collection;

public class ResultPage<T>
extends ArrayList<T> {
    private static final long serialVersionUID = -4553613590439485318L;
    private final int pageSize;
    private final int startIndex;
    private final int start;
    private int skippedItems;
    private int capacityLeft;

    public ResultPage(int pageSize, int startIndex) {
        this(pageSize, startIndex, true);
    }

    public ResultPage(int pageSize, int startIndex, boolean skipItems) {
        super(50);
        this.pageSize = pageSize;
        this.startIndex = startIndex;
        this.start = skipItems ? startIndex : 0;
        this.capacityLeft = pageSize;
        this.skippedItems = 0;
    }

    @Override
    public synchronized boolean add(T arg0) {
        if (this.skippedItems < this.start) {
            ++this.skippedItems;
            return true;
        }
        if (this.capacityLeft-- > 0) {
            return super.add(arg0);
        }
        return false;
    }

    public boolean hasNext() {
        return this.capacityLeft < 0;
    }

    public boolean hasPrevious() {
        return this.startIndex > 0;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    @Override
    public void add(int arg0, T arg1) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }
}

