/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.vis.vgs.gallery.cm;

import com.cognos.pogo.util.StringUtils;
import com.ibm.ba.vis.vgs.config.VGSConfiguration;
import com.ibm.ba.vis.vgs.error.ErrorMessage;
import com.ibm.ba.vis.vgs.error.GalleryAPIErrorCode;
import com.ibm.ba.vis.vgs.error.GalleryServiceErrorCode;
import com.ibm.ba.vis.vgs.error.GalleryServiceException;
import com.ibm.ba.vis.vgs.gallery.Passport;
import com.ibm.ba.vis.vgs.gallery.UpdateAction;
import com.ibm.ba.vis.vgs.gallery.cm.CMPermissions;
import com.ibm.ba.vis.vgs.gallery.cm.CMProxyObject;
import com.ibm.ba.vis.vgs.gallery.cm.CamHttpClientFactory;
import com.ibm.ba.vis.vgs.gallery.cm.HttpClientFactory;
import com.ibm.ba.vis.vgs.gallery.cm.HttpResponseEntity;
import com.ibm.ba.vis.vgs.gallery.cm.MultiPartSoapRequestEntity;
import com.ibm.ba.vis.vgs.gallery.cm.ResponseEntity;
import com.ibm.ba.vis.vgs.gallery.cm.VelocityLogSystemStub;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.map.LinkedMap;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.StatusLine;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.io.IOUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

class CMClient {
    static final String CM_NAME_CONFLICT_ERROR = "CM-REQ-4024";
    static final String CAM_AUTH_ERROR = "CM-CAM-4005";
    static final String NAME = "name";
    static final String TYPE = "extensions";
    static final String ICON = "iconURI";
    static final String OBJECT_CLASS = "objectClass";
    static final String DESCRIPTION = "description";
    static final String SCREEN_TIP = "screenTip";
    static final String COOKIE_HEADER = "Cookie";
    static final String CAM_PASSPORT_COOKIE = "cam_passport=";
    static final String IF_NONE_MATCH_HEADER = "If-None-Match";
    static final String XSRFTOKEN_HEADER = "X-XSRF-TOKEN";
    private static Template soapQueryTemplate;
    private static Template soapAddTemplate;
    private static final String RESULT_ITEM_XPATH = "/SOAP-ENV:Envelope/SOAP-ENV:Body/bus:queryResponse/queryResult/item";
    private static final String FAULT_STRING_XPATH = "/SOAP-ENV:Envelope/SOAP-ENV:Body/SOAP-ENV:Fault/faultstring";
    private static final String FAULT_DETAIL_STRING_XPATH = "/SOAP-ENV:Envelope/SOAP-ENV:Body/SOAP-ENV:Fault/detail/bus:exception/bus:message/messageString";
    private final HttpClientFactory httpClientFactory;
    private final VGSConfiguration config;
    private final SAXReader reader;
    private HttpClient httpClient;
    private static final Pattern ELEMENT_PATTERN;
    private static Map<String, String> nsUriMap;

    CMClient() {
        this(CamHttpClientFactory.getInstance(), VGSConfiguration.getInstance());
    }

    CMClient(HttpClientFactory httpClientFactory, VGSConfiguration config) {
        this.config = config;
        this.httpClientFactory = httpClientFactory;
        this.reader = new SAXReader();
        CMClient.loadTemplates();
    }

    ResponseEntity requestObjectData(Passport passport, String storeID, String eTag) {
        String cmRestURI = this.config.getValue("contentManagerRest");
        String restURI = cmRestURI + "/" + storeID + "/data";
        GetMethod getMethod = this.createGetMethod(restURI, passport, eTag);
        try {
            int statusCode = this.executeMethod((HttpMethod)getMethod);
            if (statusCode == 200 || statusCode == 304) {
                return new HttpResponseEntity((HttpMethod)getMethod);
            }
            if (statusCode == 404) {
                ErrorMessage errorMessage = new ErrorMessage(GalleryAPIErrorCode.requestedResourceNotFound);
                errorMessage.addParameter("storeID", storeID);
                throw new GalleryServiceException(errorMessage);
            }
            throw this.getUnexpectedResponseException(getMethod.getStatusLine());
        }
        catch (GalleryServiceException e) {
            this.releaseConnectionQuietly((HttpMethod)getMethod);
            throw e;
        }
        catch (Exception e) {
            this.releaseConnectionQuietly((HttpMethod)getMethod);
            ErrorMessage errorMessage = new ErrorMessage(GalleryServiceErrorCode.failedToAccessResource);
            errorMessage.addParameter("storeID", storeID);
            throw new GalleryServiceException(errorMessage, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<String, CMProxyObject> queryObjects(Passport passport, String searchPath, Set<String> requestedProps, int startIndex, int pageSize) {
        Map<String, CMProxyObject> objectMap = Collections.emptyMap();
        String cmURI = this.config.getValue("contentManager");
        PostMethod postMethod = this.createPostMethod(cmURI);
        try {
            HashSet<String> props = new HashSet<String>(requestedProps.size() + 1);
            props.addAll(requestedProps);
            props.add("storeID");
            RequestEntity reqEntity = this.createQueryRequest(passport, searchPath, props, startIndex, pageSize);
            postMethod.setRequestEntity(reqEntity);
            this.executeMethod((HttpMethod)postMethod);
            this.validateSoapRequest(postMethod);
            Document soapResponse = this.parseSoapResponse(postMethod);
            objectMap = this.extractObjects(soapResponse);
        }
        finally {
            this.releaseConnectionQuietly((HttpMethod)postMethod);
        }
        return objectMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String store(Passport passport, String parentPath, Map<String, Object> properties, InputStream data, String contentType, UpdateAction updateAction) {
        String cmURI = this.config.getValue("contentManager");
        PostMethod postMethod = this.createPostMethod(cmURI);
        try {
            RequestEntity reqEntity = this.createAddRequest(passport, parentPath, properties, data, contentType, updateAction);
            postMethod.setRequestEntity(reqEntity);
            this.executeMethod((HttpMethod)postMethod);
            this.validateSoapRequest(postMethod);
            Document soapResponse = this.parseSoapResponse(postMethod);
            String string = this.getNodeText((Node)soapResponse, "/SOAP-ENV:Envelope/SOAP-ENV:Body/bus:addResponse/addResult/item/storeID/value");
            return string;
        }
        finally {
            this.releaseConnectionQuietly((HttpMethod)postMethod);
        }
    }

    boolean hasPermissions(Passport passport, String storeID, CMPermissions ... permissions) {
        boolean hasPermissions = true;
        String cmRestURI = this.config.getValue("contentManagerRest");
        String restURI = cmRestURI + "/" + storeID + "/permissions";
        GetMethod getMethod = this.createGetMethod(restURI, passport, null);
        try {
            int statusCode = this.executeMethod((HttpMethod)getMethod);
            if (statusCode == 200) {
                String body = getMethod.getResponseBodyAsString();
                Set<CMPermissions> permissionSet = CMPermissions.fromJSONArray(body);
                for (CMPermissions permission : permissions) {
                    hasPermissions &= permissionSet.contains((Object)permission);
                }
                boolean bl = hasPermissions;
                return bl;
            }
            try {
                throw this.getUnexpectedResponseException(getMethod.getStatusLine());
            }
            catch (IOException e) {
                throw new GalleryServiceException(GalleryServiceErrorCode.internalServiceError, (Throwable)e);
            }
        }
        finally {
            this.releaseConnectionQuietly((HttpMethod)getMethod);
        }
    }

    boolean hasCapabilities(Passport passport, String ... capabilities) {
        boolean hasCapabilities = true;
        String cmRestURI = this.config.getValue("contentManagerUserRest");
        String restURI = cmRestURI + "/users/~/capabilities";
        GetMethod getMethod = this.createGetMethod(restURI, passport, null);
        getMethod.removeRequestHeader(COOKIE_HEADER);
        getMethod.addRequestHeader(COOKIE_HEADER, passport.getCookies());
        getMethod.addRequestHeader(XSRFTOKEN_HEADER, passport.getXsrfToken());
        try {
            int statusCode = this.executeMethod((HttpMethod)getMethod);
            if (statusCode == 200) {
                String body = getMethod.getResponseBodyAsString();
                Set<String> capabilitiesSet = CMClient.setFromJSONArray(body);
                for (String capability : capabilities) {
                    hasCapabilities &= capabilitiesSet.contains(capability);
                }
                boolean bl = hasCapabilities;
                return bl;
            }
            try {
                throw this.getUnexpectedResponseException(getMethod.getStatusLine());
            }
            catch (IOException e) {
                throw new GalleryServiceException(GalleryServiceErrorCode.internalServiceError, (Throwable)e);
            }
        }
        finally {
            this.releaseConnectionQuietly((HttpMethod)getMethod);
        }
    }

    static Set<String> setFromJSONArray(String jsonValue) {
        Matcher matcher = ELEMENT_PATTERN.matcher(jsonValue);
        HashSet<String> stringSet = new HashSet<String>();
        while (matcher.find()) {
            stringSet.add(matcher.group(1));
        }
        return stringSet;
    }

    private synchronized void initializeClient() {
        if (this.httpClient == null) {
            try {
                String cmURI = this.config.getValue("contentManager");
                this.httpClient = this.httpClientFactory.create(cmURI);
            }
            catch (IOException e) {
                throw new GalleryServiceException(GalleryServiceErrorCode.internalServiceError, (Throwable)e);
            }
        }
    }

    private RequestEntity createQueryRequest(Passport passport, String searchPath, Set<String> props, int startIndex, int pageSize) {
        StringWriter writer = new StringWriter();
        VelocityContext context = new VelocityContext();
        context.put("cam_passportId", (Object)passport.getPassportValue());
        context.put("path", (Object)searchPath);
        context.put("skipObjects", (Object)startIndex);
        context.put("maxObjects", (Object)pageSize);
        context.put("properties", props);
        if (pageSize > 1) {
            context.put("orderByName", (Object)true);
        }
        try {
            soapQueryTemplate.merge((Context)context, (Writer)writer);
        }
        catch (Exception e) {
            throw new GalleryServiceException(GalleryServiceErrorCode.internalServiceError, (Throwable)new IOException("Unable to create SOAP Query request", e));
        }
        try {
            return new StringRequestEntity(writer.toString(), "text/xml", "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new GalleryServiceException(GalleryServiceErrorCode.internalServiceError, (Throwable)e);
        }
    }

    private RequestEntity createAddRequest(Passport passport, String parentPath, Map<String, Object> properties, InputStream data, String contentType, UpdateAction updateAction) {
        StringWriter writer = new StringWriter();
        VelocityContext context = new VelocityContext();
        context.put("cam_passportId", (Object)passport.getPassportValue());
        context.put("path", (Object)parentPath);
        context.put("updateAction", (Object)updateAction.name().toLowerCase(Locale.ROOT));
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            context.put(entry.getKey(), entry.getValue());
        }
        InputStream dataStream = data;
        if (dataStream != null) {
            context.put("isDataIncluded", (Object)true);
        } else {
            dataStream = new ByteArrayInputStream(new byte[0]);
        }
        try {
            soapAddTemplate.merge((Context)context, (Writer)writer);
        }
        catch (Exception e) {
            throw new GalleryServiceException(GalleryServiceErrorCode.internalServiceError, (Throwable)new IOException("Unable to create SOAP Add request", e));
        }
        return new MultiPartSoapRequestEntity(writer.toString(), dataStream, contentType);
    }

    private PostMethod createPostMethod(String uri) {
        PostMethod postMethod = new PostMethod(uri);
        postMethod.setDoAuthentication(true);
        return postMethod;
    }

    private GetMethod createGetMethod(String uri, Passport passport, String eTag) {
        GetMethod getMethod = new GetMethod(uri);
        getMethod.setDoAuthentication(true);
        if (StringUtils.isNotEmpty((String)eTag)) {
            getMethod.addRequestHeader(IF_NONE_MATCH_HEADER, eTag);
        }
        getMethod.addRequestHeader(COOKIE_HEADER, CAM_PASSPORT_COOKIE + passport.getEncodedPassportValue());
        return getMethod;
    }

    private int executeMethod(HttpMethod method) {
        try {
            this.initializeClient();
            method.getParams().setCookiePolicy("ignoreCookies");
            return this.httpClient.executeMethod(method);
        }
        catch (IOException e) {
            throw new GalleryServiceException(GalleryServiceErrorCode.failedToAccessContentManager, (Throwable)e);
        }
    }

    private Map<String, CMProxyObject> extractObjects(Document queryResponse) {
        LinkedMap objectMap;
        List resultNodes = queryResponse.selectNodes(RESULT_ITEM_XPATH);
        int size = resultNodes.size();
        if (size > 0) {
            objectMap = new LinkedMap(size);
            for (Node node : resultNodes) {
                CMProxyObject proxyObject = this.extractObject((Element)node);
                objectMap.put(proxyObject.getStoreID(), proxyObject);
            }
        } else {
            objectMap = Collections.emptyMap();
        }
        return objectMap;
    }

    private CMProxyObject extractObject(Element element) {
        List propElements = element.elements();
        HashMap<String, String> props = new HashMap<String, String>(propElements.size(), 1.0f);
        for (Element propElement : propElements) {
            String name = propElement.getName();
            String value = this.getNodeText((Node)propElement, "./value");
            props.put(name, value);
        }
        String storeID = (String)props.get("storeID");
        return new CMProxyObject(storeID, props);
    }

    private void validateSoapRequest(PostMethod postMethod) {
        Header contentType;
        if (postMethod.getStatusCode() == 200 && (contentType = postMethod.getResponseHeader("Content-Type")) != null && contentType.getValue().startsWith("text/xml")) {
            return;
        }
        StringBuilder sb = new StringBuilder("Unsuccessful request");
        this.appendErrorMessage(sb, postMethod);
        String errorString = sb.toString();
        IOException ioe = new IOException(errorString);
        if (errorString.contains(CM_NAME_CONFLICT_ERROR)) {
            throw new GalleryServiceException(GalleryAPIErrorCode.objectNameConflict, (Throwable)ioe);
        }
        throw new GalleryServiceException(GalleryServiceErrorCode.internalServiceError, (Throwable)ioe);
    }

    private Document parseSoapResponse(PostMethod postMethod) {
        Document soapResponse;
        try {
            soapResponse = this.parseResponseBody(postMethod);
        }
        catch (Exception e) {
            throw new GalleryServiceException(GalleryServiceErrorCode.failedToAccessContentManager, (Throwable)e);
        }
        return soapResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document parseResponseBody(PostMethod postMethod) throws DocumentException, IOException {
        Document xmlDoc;
        SAXReader sAXReader = this.reader;
        synchronized (sAXReader) {
            xmlDoc = this.reader.read(postMethod.getResponseBodyAsStream());
        }
        return xmlDoc;
    }

    private void appendErrorMessage(StringBuilder sb, PostMethod postMethod) {
        Header contentType;
        if (postMethod.getStatusCode() >= 400) {
            sb.append("\r\n").append(postMethod.getStatusLine());
        }
        if ((contentType = postMethod.getResponseHeader("Content-Type")) != null && contentType.getValue().startsWith("text/xml")) {
            try {
                Document xmlDoc = this.parseResponseBody(postMethod);
                this.appendSoapFaultMsg(sb, xmlDoc);
            }
            catch (GalleryServiceException e) {
                throw e;
            }
            catch (Exception e) {
                sb.append("\r\nInvalid SOAP response");
            }
        }
    }

    private void appendSoapFaultMsg(StringBuilder sb, Document xmlDoc) {
        String faultDetailString;
        String faultString = this.getNodeText((Node)xmlDoc, FAULT_STRING_XPATH);
        if (faultString != null) {
            sb.append("\r\n").append(faultString);
        }
        if ((faultDetailString = this.getNodeText((Node)xmlDoc, FAULT_DETAIL_STRING_XPATH)) != null) {
            if (faultDetailString.contains(CAM_AUTH_ERROR)) {
                throw new GalleryServiceException(GalleryAPIErrorCode.insufficientAccessRights);
            }
            sb.append("\r\n").append(faultDetailString);
        }
    }

    private String getNodeText(Node node, String xpath) {
        String nodeText = null;
        List nodes = node.selectNodes(xpath);
        if (nodes.size() > 0) {
            nodeText = ((Node)nodes.get(0)).getText();
        }
        return nodeText;
    }

    private GalleryServiceException getUnexpectedResponseException(StatusLine statusLine) {
        GalleryServiceException gse;
        if (401 == statusLine.getStatusCode()) {
            gse = new GalleryServiceException(GalleryAPIErrorCode.insufficientAccessRights);
        } else {
            RuntimeException re = new RuntimeException("Unexpected response: " + statusLine.getReasonPhrase());
            gse = new GalleryServiceException(GalleryServiceErrorCode.internalServiceError, (Throwable)re);
        }
        return gse;
    }

    private void releaseConnectionQuietly(HttpMethod httpMethod) {
        if (httpMethod != null) {
            try {
                httpMethod.releaseConnection();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void setupDom4j() {
        nsUriMap = new HashMap<String, String>();
        nsUriMap.put("SOAP-ENV", "http://schemas.xmlsoap.org/soap/envelope/");
        nsUriMap.put("SENV", "http://schemas.xmlsoap.org/soap/envelope/");
        nsUriMap.put("SOAP-ENC", "http://schemas.xmlsoap.org/soap/encoding/");
        nsUriMap.put("SENC", "http://schemas.xmlsoap.org/soap/encoding/");
        nsUriMap.put("xsd", "http://www.w3.org/2001/XMLSchema");
        nsUriMap.put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        nsUriMap.put("bus", "http://developer.cognos.com/schemas/bibus/3/");
        nsUriMap.put("cm1", "http://developer.cognos.com/schemas/contentManagerService/1");
    }

    private static void setupVelocity() {
        Properties properties = new Properties();
        properties.put("resource.loader", "class");
        properties.put("runtime.log.logsystem.class", VelocityLogSystemStub.class.getName());
        properties.put("class.resource.loader.description", "Velocity Classpath Resource Loader");
        properties.put("class.resource.loader.class", "org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
        try {
            Velocity.init((Properties)properties);
        }
        catch (Exception e) {
            throw new GalleryServiceException(GalleryServiceErrorCode.internalServiceError, (Throwable)e);
        }
    }

    private static synchronized void loadTemplates() {
        if (soapQueryTemplate == null) {
            soapQueryTemplate = CMClient.loadTemplate("SoapQueryStoreID.xml");
        }
        if (soapAddTemplate == null) {
            soapAddTemplate = CMClient.loadTemplate("SoapAddDataAttachment.xml");
        }
    }

    private static Template loadTemplate(String resourceName) {
        InputStream is = null;
        try {
            URI resourceURI = URI.create(CMClient.class.getName().replace('.', '/'));
            resourceURI = resourceURI.resolve(URI.create(resourceName));
            Template template = Velocity.getTemplate((String)resourceURI.getPath());
            return template;
        }
        catch (Exception e) {
            throw new GalleryServiceException(GalleryServiceErrorCode.internalServiceError, (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly(is);
        }
    }

    static {
        CMClient.setupDom4j();
        CMClient.setupVelocity();
        ELEMENT_PATTERN = Pattern.compile("(?:[\\[,][ ]?[\"](\\w+)[\"])");
    }
}

