/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.vis.vgs.gallery.cm;

import com.cognos.i18n.DateTimeFormat;
import com.cognos.i18n.TimeZone;
import com.ibm.ba.vis.vgs.VgsApplicationModule;
import com.ibm.ba.vis.vgs.bundle.DefinitionManager;
import com.ibm.ba.vis.vgs.bundle.NullBundle;
import com.ibm.ba.vis.vgs.bundle.VisBundle;
import com.ibm.ba.vis.vgs.config.VGSConfiguration;
import com.ibm.ba.vis.vgs.error.ErrorMessage;
import com.ibm.ba.vis.vgs.error.GalleryAPIErrorCode;
import com.ibm.ba.vis.vgs.error.GalleryServiceErrorCode;
import com.ibm.ba.vis.vgs.error.GalleryServiceException;
import com.ibm.ba.vis.vgs.gallery.GalleryManager;
import com.ibm.ba.vis.vgs.gallery.Passport;
import com.ibm.ba.vis.vgs.gallery.UpdateAction;
import com.ibm.ba.vis.vgs.gallery.cache.CacheManager;
import com.ibm.ba.vis.vgs.gallery.cache.LocalCacheManager;
import com.ibm.ba.vis.vgs.gallery.cache.ResultPage;
import com.ibm.ba.vis.vgs.gallery.cm.CMClient;
import com.ibm.ba.vis.vgs.gallery.cm.CMPermissions;
import com.ibm.ba.vis.vgs.gallery.cm.CMProxyObject;
import com.ibm.ba.vis.vgs.gallery.cm.CorruptedBundleHandle;
import com.ibm.ba.vis.vgs.gallery.cm.MLString;
import com.ibm.ba.vis.vgs.gallery.cm.ResponseEntity;
import com.ibm.ba.vis.vgs.gallery.fs.CachedGalleryManager;
import com.ibm.ba.vis.vgs.gallery.fs.FileSystemVisBundle;
import com.ibm.ba.vis.vgs.resources.ResourceManagerFactory;
import com.ibm.cognos.rs.core.Status;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;

public class CMGalleryManager
implements GalleryManager {
    static final String TENANTID_PROP = "tenantID";
    static final String DEFAULT_SCREEN_TIP = "defaultScreenTip";
    static final String DEFAULT_DESCRIPTION = "defaultDescription";
    static final String REPSREDIRECT_SYSPROP = "com.ibm.ba.vis.vgs.gallery.cm.repsredirect";
    static final String GALLERY_SEARCHPATH = "/catalog/catalogFolder[@name='Visualizations']";
    static final String TENANT_FOLDER_PREFIX = "#";
    static final String TENANT_TOKEN = "#TENANT#";
    static final String TENANT_GALLERY_SEARCHPATH = "/catalog/catalogFolder[@name='Visualizations']/catalogFolder";
    static final String TENANT_GALLERY_NAMED_SEARCHPATH = "/catalog/catalogFolder[@name='Visualizations']/catalogFolder[@name='##TENANT#']";
    static final String VIS_SEARCH_FILTER = "[@shown='true'][permission('read')]";
    static final String GALLERY_CHILDREN = "/catalog/catalogFolder[@name='Visualizations']/visualization[@shown='true'][permission('read')]";
    static final String TENANT_GALLERY_CHILDREN = "/catalog/catalogFolder[@name='Visualizations']/catalogFolder/visualization[@shown='true'][permission('read')]";
    static final String ID_TOKEN = "#ID_TOKEN#";
    static final String VIS_BUNDLE_SEARCHPATH = "/catalog/catalogFolder[@name='Visualizations']//visualization[@name='#ID_TOKEN#'][@shown='true'][permission('read')]";
    static final Set<String> BUNDLE_PROPS = new HashSet<String>();
    private static final DateTimeFormat UTC_FORMAT = new DateTimeFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
    private final GalleryManager cachedGalleryManager;
    private final CMClient cmClient;
    private final CacheManager cacheManager;
    private final VGSConfiguration config;
    private volatile Set<String> localesSet;

    public CMGalleryManager(DefinitionManager definitionManager, ResourceManagerFactory resourceFactory) {
        this(new CachedGalleryManager(definitionManager, resourceFactory));
    }

    CMGalleryManager(GalleryManager localGalleryManager) {
        this(localGalleryManager, new CMClient(), LocalCacheManager.getInstance(), VGSConfiguration.getInstance());
    }

    CMGalleryManager(GalleryManager localGalleryManager, CMClient cmClient, CacheManager cacheManager, VGSConfiguration config) {
        this.cachedGalleryManager = localGalleryManager;
        this.cmClient = cmClient;
        this.cacheManager = cacheManager;
        this.config = config;
    }

    @Override
    public ResultPage<VisBundle> list(Passport passport, int startIndex, int pageSize, String language, boolean custom) {
        String searchPath = custom ? TENANT_GALLERY_CHILDREN : GALLERY_CHILDREN;
        Map<String, CMProxyObject> results = this.cmClient.queryObjects(passport, searchPath, BUNDLE_PROPS, startIndex, pageSize + 1);
        return this.loadBundles(passport, results, startIndex, pageSize, language, custom);
    }

    private ResultPage<VisBundle> loadBundles(Passport passport, Map<String, CMProxyObject> results, int startIndex, int pageSize, String language, boolean custom) {
        ResultPage<VisBundle> resultPage = new ResultPage<VisBundle>(pageSize, startIndex, false);
        results.entrySet().parallelStream().forEach(b -> {
            boolean customViz;
            CMProxyObject cmBundleProps = (CMProxyObject)b.getValue();
            VisBundle bundle = this.getBundle(passport, cmBundleProps, language);
            boolean bl = customViz = bundle instanceof FileSystemVisBundle && bundle.isCustomViz();
            if (customViz == custom) {
                if (custom) {
                    this.updateCustomBundleFromCM((FileSystemVisBundle)bundle, cmBundleProps);
                }
                resultPage.add(bundle);
            }
        });
        if (custom) {
            this.removeDuplicateBundleIds(resultPage);
        }
        return resultPage;
    }

    void removeDuplicateBundleIds(ResultPage<VisBundle> resultPage) {
        HashMap<String, FileSystemVisBundle> idToBundle = new HashMap<String, FileSystemVisBundle>();
        ArrayList<Object> toRemove = new ArrayList<Object>();
        for (FileSystemVisBundle fileSystemVisBundle : resultPage) {
            String string = fileSystemVisBundle.getId();
            if (idToBundle.get(string) != null) {
                if (((FileSystemVisBundle)idToBundle.get(string)).getTenant().length() == 0) {
                    toRemove.add(idToBundle.get(string));
                } else {
                    toRemove.add(fileSystemVisBundle);
                    continue;
                }
            }
            idToBundle.put(string, fileSystemVisBundle);
        }
        for (VisBundle visBundle : toRemove) {
            resultPage.remove(visBundle);
        }
    }

    private void updateCustomBundleFromCM(FileSystemVisBundle bundle, CMProxyObject cmBundleProps) {
        bundle.setName(cmBundleProps.getProperty(DEFAULT_SCREEN_TIP));
        bundle.setDescription(cmBundleProps.getProperty(DEFAULT_DESCRIPTION));
        bundle.setTenant(cmBundleProps.getProperty(TENANTID_PROP));
    }

    private VisBundle getBundle(Passport passport, CMProxyObject cmProxyObject, String language) {
        VisBundle bundle;
        String storeID = cmProxyObject.getStoreID();
        String visId = cmProxyObject.getProperty("defaultName");
        try {
            this.loadBundle(passport, storeID, visId);
            bundle = this.cachedGalleryManager.get(passport, storeID, language);
            String modDateString = cmProxyObject.getProperty("modificationTime");
            this.updateBundleModificationDate(bundle, modDateString);
        }
        catch (GalleryServiceException gse) {
            if (Status.NOT_FOUND.equals((Object)gse.getStatus())) {
                bundle = new NullBundle();
            }
            if (Status.BAD_REQUEST.equals((Object)gse.getStatus())) {
                ErrorMessage errorMessage = new ErrorMessage(GalleryServiceErrorCode.corruptedCMBundle);
                errorMessage.addParameter("storeID", storeID + " (" + visId + ")");
                gse.addError(errorMessage);
                this.getLog().warn((Object)gse.getMessage(), (Throwable)gse);
                bundle = new CorruptedBundleHandle(storeID);
            }
            throw gse;
        }
        return bundle;
    }

    private void loadBundle(Passport passport, String storeID, String visId) {
        ResponseEntity responseEntity = this.requestData(passport, storeID, visId);
        try {
            if (responseEntity.isModified()) {
                String newEtag = responseEntity.getHeaderValue("ETag");
                this.cacheManager.store(storeID, newEtag, responseEntity.getBodyStream());
            }
        }
        catch (IOException e) {
            throw new GalleryServiceException(GalleryServiceErrorCode.internalServiceError, (Throwable)e);
        }
        finally {
            responseEntity.release();
        }
    }

    private ResponseEntity requestData(Passport passport, String storeID, String visId) {
        try {
            String eTag = this.cacheManager.getETag(storeID);
            return this.cmClient.requestObjectData(passport, storeID, eTag);
        }
        catch (GalleryServiceException e) {
            if (Status.NOT_FOUND.equals((Object)e.getStatus())) {
                ErrorMessage errorMessage = new ErrorMessage(GalleryAPIErrorCode.requestedBundleNotFound);
                errorMessage.addParameter("bundleId", visId);
                e.addError(errorMessage);
            }
            throw e;
        }
    }

    private void updateBundleModificationDate(VisBundle bundle, String modDateString) {
        if (bundle != null && StringUtils.isNotEmpty((String)modDateString)) {
            bundle.setLastUpdatedAsString(modDateString);
            try {
                Date modDate = UTC_FORMAT.parse(modDateString.trim()).getTime();
                bundle.setLastUpdated(modDate);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public VisBundle get(Passport passport, String visId, String lang) {
        CMProxyObject cmBundle;
        VisBundle bundle = null;
        String bundleSearchPath = VIS_BUNDLE_SEARCHPATH.replace(ID_TOKEN, visId);
        Map<String, CMProxyObject> queryResults = this.cmClient.queryObjects(passport, bundleSearchPath, BUNDLE_PROPS, 0, 1);
        Iterator<CMProxyObject> entryIterator = queryResults.values().iterator();
        if (entryIterator.hasNext()) {
            cmBundle = entryIterator.next();
            while (entryIterator.hasNext() && cmBundle.getProperty(TENANTID_PROP).length() == 0) {
                cmBundle = entryIterator.next();
            }
        } else {
            ErrorMessage errorMessage = new ErrorMessage(GalleryAPIErrorCode.requestedBundleNotFound);
            errorMessage.addParameter("bundleId", visId);
            throw new GalleryServiceException(errorMessage);
        }
        bundle = this.getBundle(passport, visId, lang, cmBundle);
        return bundle;
    }

    private VisBundle getBundle(Passport passport, String visId, String lang, CMProxyObject cmProxyObject) {
        String storeID = cmProxyObject.getStoreID();
        this.loadBundle(passport, storeID, visId);
        VisBundle bundle = this.cachedGalleryManager.get(passport, storeID, lang);
        String modDateString = cmProxyObject.getProperty("modificationTime");
        this.updateBundleModificationDate(bundle, modDateString);
        if (this.isRedirectToRepsEnabled()) {
            String contentPath = "repository/sid/cm/oid/" + storeID + "/content";
            URI contentURI = URI.create(contentPath);
            bundle.setContentURI(contentURI);
        }
        return bundle;
    }

    private boolean isRedirectToRepsEnabled() {
        return Boolean.valueOf(System.getProperty(REPSREDIRECT_SYSPROP, "true"));
    }

    @Override
    public String store(Passport passport, InputStream bundleStream, UpdateAction updateAction) {
        String string;
        String bundleTempName = null;
        File compressedBundle = null;
        FileInputStream upStream = null;
        try {
            String bundleSearchPath;
            Map<String, CMProxyObject> queryResults;
            Iterator<CMProxyObject> entryIterator;
            try {
                this.checkCapabilities(passport, "canUseAdministrationPortal", "canUsePortalAdministrationTool");
            }
            catch (GalleryServiceException e) {
                this.checkCapabilities(passport, "canUseAdministrationPortal", "canManageVisualizations");
            }
            catch (Exception e) {
                throw e;
            }
            bundleTempName = this.cachedGalleryManager.store(passport, bundleStream, updateAction);
            VisBundle visBundle = this.getBundleFromCache(bundleTempName);
            if (updateAction.equals((Object)UpdateAction.FAIL) && (entryIterator = (queryResults = this.cmClient.queryObjects(passport, bundleSearchPath = VIS_BUNDLE_SEARCHPATH.replace(ID_TOKEN, visBundle.getId()), BUNDLE_PROPS, 0, 1)).values().iterator()).hasNext()) {
                ErrorMessage errorMessage = new ErrorMessage(GalleryAPIErrorCode.bundleAlreadyExists);
                errorMessage.addParameter("bundleId", visBundle.getId());
                throw new GalleryServiceException(errorMessage);
            }
            String searchPath = GALLERY_SEARCHPATH;
            String tenantID = "";
            boolean isCustom = visBundle.isCustomViz();
            if (isCustom) {
                tenantID = this.getUserTenantID(passport);
                searchPath = TENANT_GALLERY_NAMED_SEARCHPATH.replace(TENANT_TOKEN, tenantID);
            }
            String catalogStoreID = this.getVisCatalogStoreID(passport, isCustom, searchPath, tenantID);
            this.checkPermissions(passport, catalogStoreID, CMPermissions.WRITE, CMPermissions.TRAVERSE);
            compressedBundle = new File(visBundle.getContentURI());
            upStream = new FileInputStream(compressedBundle);
            this.storeBundleInCM(passport, visBundle, upStream, updateAction, searchPath);
            string = visBundle.getId();
        }
        catch (IOException e) {
            try {
                throw new GalleryServiceException(GalleryServiceErrorCode.internalServiceError, (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(upStream);
                FileUtils.deleteQuietly(compressedBundle);
                this.cacheManager.removeQuietly(bundleTempName);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)upStream);
        FileUtils.deleteQuietly((File)compressedBundle);
        this.cacheManager.removeQuietly(bundleTempName);
        return string;
    }

    private void checkCapabilities(Passport passport, String ... capabilities) {
        boolean hasCapabilities = this.cmClient.hasCapabilities(passport, capabilities);
        if (!hasCapabilities) {
            throw new GalleryServiceException(GalleryAPIErrorCode.insufficientCapabilities);
        }
    }

    private void checkPermissions(Passport passport, String storeID, CMPermissions ... permissions) throws IOException {
        boolean hasPermissions = this.cmClient.hasPermissions(passport, storeID, permissions);
        if (!hasPermissions) {
            throw new GalleryServiceException(GalleryAPIErrorCode.insufficientAccessRights);
        }
    }

    String getVisCatalogStoreID(Passport passport, boolean isCustom, String searchPath, String tenantID) throws IOException {
        String catalogStoreID;
        Map<String, CMProxyObject> qResult = this.cmClient.queryObjects(passport, searchPath, BUNDLE_PROPS, 0, 1);
        if (qResult.size() > 0) {
            catalogStoreID = qResult.keySet().iterator().next();
        } else if (isCustom) {
            catalogStoreID = this.createTenantCatalogFolder(passport, searchPath, tenantID);
        } else {
            throw new GalleryServiceException(GalleryAPIErrorCode.insufficientAccessRights);
        }
        return catalogStoreID;
    }

    private String createTenantCatalogFolder(Passport passport, String searchPath, String tenantID) throws IOException {
        HashMap<String, Object> properties = new HashMap<String, Object>(4, 1.0f);
        properties.put("objectClass", "catalogFolder");
        properties.put("name", TENANT_FOLDER_PREFIX + tenantID);
        try {
            return this.cmClient.store(passport, GALLERY_SEARCHPATH, properties, null, null, UpdateAction.FAIL);
        }
        catch (GalleryServiceException gse) {
            if (Status.CONFLICT.equals((Object)gse.getStatus())) {
                return this.getVisCatalogStoreID(passport, true, searchPath, tenantID);
            }
            throw new GalleryServiceException(GalleryAPIErrorCode.insufficientAccessRights);
        }
    }

    private VisBundle getBundleFromCache(String visId) {
        try {
            return this.cachedGalleryManager.get(null, visId, "en");
        }
        catch (GalleryServiceException gse) {
            gse.addError(GalleryAPIErrorCode.invalidBundleFormat);
            throw gse;
        }
        catch (Exception e) {
            throw new GalleryServiceException(GalleryAPIErrorCode.invalidBundleFormat, (Throwable)e);
        }
    }

    private void storeBundleInCM(Passport passport, VisBundle visBundle, InputStream upStream, UpdateAction updateAction, String searchPath) throws IOException {
        String bundleStoreID;
        block2: {
            HashMap<String, Object> properties = new HashMap<String, Object>(4, 1.0f);
            properties.put("objectClass", "visualization");
            properties.put("name", visBundle.getId());
            properties.put("extensions", visBundle.getType());
            properties.put("iconURI", visBundle.getIcon());
            properties.put("description", visBundle.getDescription("en"));
            Set<String> langs = visBundle.getLanguages();
            List<MLString> mlDescription = this.getMlDescription(visBundle, langs);
            properties.put("description", mlDescription);
            List<MLString> mlName = this.getMlName(visBundle, langs);
            properties.put("screenTip", mlName);
            bundleStoreID = null;
            try {
                bundleStoreID = this.cmClient.store(passport, searchPath, properties, upStream, "application/zip", updateAction);
            }
            catch (GalleryServiceException gse) {
                if (!Status.CONFLICT.equals((Object)gse.getStatus())) break block2;
                ErrorMessage errorMessage = new ErrorMessage(GalleryAPIErrorCode.bundleAlreadyExists);
                errorMessage.addParameter("bundleId", visBundle.getId());
                gse.addError(errorMessage);
                throw gse;
            }
        }
        this.loadBundle(passport, bundleStoreID, visBundle.getId());
    }

    private List<MLString> getMlName(final VisBundle visBundle, Set<String> langs) {
        return this.getMlValue(new ValueHandle(){

            @Override
            public String getValue(String lang) {
                return visBundle.getName(lang);
            }
        }, langs);
    }

    private List<MLString> getMlDescription(final VisBundle visBundle, Set<String> langs) {
        return this.getMlValue(new ValueHandle(){

            @Override
            public String getValue(String lang) {
                return visBundle.getDescription(lang);
            }
        }, langs);
    }

    private List<MLString> getMlValue(ValueHandle handle, Set<String> langs) {
        ArrayList<MLString> mlValue = new ArrayList<MLString>(langs.size());
        Set<String> locales = this.getConfiguredLocales();
        for (String lang : langs) {
            String value;
            String localeString = lang.toLowerCase(Locale.ROOT).replace('_', '-');
            if (!locales.contains(localeString) || !StringUtils.isNotEmpty((String)(value = handle.getValue(lang)))) continue;
            mlValue.add(new MLString(localeString, value));
        }
        return mlValue;
    }

    private Set<String> getConfiguredLocales() {
        if (this.localesSet == null || this.localesSet.isEmpty()) {
            String locales = this.config.getValue("locales");
            String[] localesArray = StringUtils.split((String)locales, (char)',');
            this.localesSet = new HashSet<String>(Arrays.asList(localesArray));
        }
        return this.localesSet;
    }

    private Log getLog() {
        return VgsApplicationModule.getModuleLog();
    }

    private String getETag(String bundleName) {
        return "version=1";
    }

    private String getUserTenantID(Passport passport) {
        Map<String, CMProxyObject> queryResults = this.cmClient.queryObjects(passport, "~", new HashSet<String>(Arrays.asList(TENANTID_PROP)), 0, 1);
        return queryResults.entrySet().iterator().next().getValue().getProperty(TENANTID_PROP);
    }

    static {
        BUNDLE_PROPS.add("storeID");
        BUNDLE_PROPS.add("defaultName");
        BUNDLE_PROPS.add("extensions");
        BUNDLE_PROPS.add("iconURI");
        BUNDLE_PROPS.add("modificationTime");
        BUNDLE_PROPS.add(TENANTID_PROP);
        BUNDLE_PROPS.add(DEFAULT_SCREEN_TIP);
        BUNDLE_PROPS.add(DEFAULT_DESCRIPTION);
        UTC_FORMAT.setTimeZone(TimeZone.getTimeZone((String)"UTC"));
    }

    private static interface ValueHandle {
        public String getValue(String var1);
    }
}

