/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.vis.vgs.gallery.cm;

import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

enum CMPermissions {
    EXECUTE,
    READ,
    SETPOLICY,
    TRAVERSE,
    WRITE;

    private static final Pattern ELEMENT_PATTERN;

    static CMPermissions fromString(String value) {
        String uValue = value.trim().toUpperCase(Locale.ROOT);
        return CMPermissions.valueOf(uValue);
    }

    static Set<CMPermissions> fromJSONArray(String body) {
        Matcher matcher = ELEMENT_PATTERN.matcher(body);
        HashSet<CMPermissions> permissions = new HashSet<CMPermissions>(5);
        while (matcher.find()) {
            permissions.add(CMPermissions.fromString(matcher.group(1)));
        }
        return permissions;
    }

    static {
        ELEMENT_PATTERN = Pattern.compile("(?:[\\[,][ ]?[\"]([a-zA-Z]+)[\"])");
    }
}

