/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.vis.vgs.gallery.cm;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.CAMFactory;
import com.ibm.ba.vis.vgs.gallery.cm.HttpClientFactory;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;

class CamHttpClientFactory
implements HttpClientFactory {
    private static final String INIT_STRING = "<initializeDocument><serviceID>VGS</serviceID></initializeDocument>";
    private static final HttpClientFactory INSTANCE = new CamHttpClientFactory(null);
    private CAMFactory camFactory;

    CamHttpClientFactory(CAMFactory camFactory) {
        this.camFactory = camFactory;
    }

    @Override
    public HttpClient create() throws IOException {
        try {
            return this.getCAMFactory().createHttpClient();
        }
        catch (CAMCryptoException e) {
            throw new IOException(e);
        }
    }

    @Override
    public HttpClient create(String hostUrl) throws IOException {
        return this.create(URI.create(hostUrl).toURL());
    }

    @Override
    public HttpClient create(URL hostUrl) throws IOException {
        try {
            HttpClient httpClient = this.getCAMFactory().createHttpClient(hostUrl);
            MultiThreadedHttpConnectionManager manager = new MultiThreadedHttpConnectionManager();
            httpClient.setHttpConnectionManager((HttpConnectionManager)manager);
            return httpClient;
        }
        catch (CAMCryptoException e) {
            throw new IOException(e);
        }
    }

    private synchronized CAMFactory getCAMFactory() throws IOException {
        if (this.camFactory == null) {
            this.camFactory = new CAMFactory();
            try {
                this.camFactory.initialize(INIT_STRING.getBytes());
            }
            catch (Exception e) {
                throw new IOException("Unable to create client.", e);
            }
        }
        return this.camFactory;
    }

    static HttpClientFactory getInstance() {
        return INSTANCE;
    }
}

