/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.vis.vgs.gallery.cm;

import com.ibm.ba.vis.vgs.gallery.cm.ResponseEntity;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpMethod;

class HttpResponseEntity
implements ResponseEntity {
    private final HttpMethod httpMethod;

    HttpResponseEntity(HttpMethod httpMethod) {
        this.httpMethod = httpMethod;
    }

    @Override
    public InputStream getBodyStream() throws IOException {
        return this.httpMethod.getResponseBodyAsStream();
    }

    @Override
    public Map<String, String> getResponseHeaders() {
        Header[] headers = this.httpMethod.getResponseHeaders();
        HashMap<String, String> headersMap = new HashMap<String, String>(headers.length, 1.0f);
        for (Header header : headers) {
            headersMap.put(header.getName(), header.getValue());
        }
        return headersMap;
    }

    @Override
    public String getHeaderValue(String headerName) {
        Header header = this.httpMethod.getResponseHeader(headerName);
        if (header != null) {
            return header.getValue();
        }
        return null;
    }

    @Override
    public int getStatusCode() {
        return this.httpMethod.getStatusCode();
    }

    @Override
    public boolean isModified() {
        return this.getStatusCode() != 304;
    }

    @Override
    public void release() {
        if (this.httpMethod != null) {
            try {
                this.httpMethod.releaseConnection();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

