/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.vis.vgs.gallery.cm;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

class MultiPartSoapRequestEntity
implements RequestEntity {
    static final String BINARY_DATA_CONTENT_TYPE = "application/octet-stream";
    static final String ZIP_CONTENT_TYPE = "application/zip";
    private final String soapMessage;
    private final InputStream attachmentInput;
    private final String contentType;
    static final String MIME_BOUNDARY = "--MIMEBoundary\n";
    static final String SOAP_CONTENT = "Content-Type: text/xml; charset=utf-8\n";
    static final String CONTENT_TYPE = "Content-Type: ";
    static final String CONTENT_ENCODING = "Content-Encoding: ";
    static final String SOAP_ID = "Content-ID: <soap>\n";
    static final String ATTACHMENT_ID = "Content-ID: <att1>\n";
    static final String CONTENT_TRANSFER_ENCODING_SOAP = "Content-Transfer-Encoding: 8-bit\n";
    static final String CONTENT_TRANSFER_ENCODING_BINARY = "Content-Transfer-Encoding: Binary\n";
    static final String CRLF = "\n";

    MultiPartSoapRequestEntity(String soapMessage, InputStream attachmentInput, String contentType) {
        this.soapMessage = soapMessage;
        this.attachmentInput = attachmentInput;
        this.contentType = StringUtils.isNotEmpty((String)contentType) ? contentType : BINARY_DATA_CONTENT_TYPE;
    }

    public String getContentType() {
        return "Multipart/Related; boundary=MIMEBoundary;type=" + this.contentType + ";";
    }

    public void writeRequest(OutputStream out) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, Charsets.UTF_8));
        writer.write(MIME_BOUNDARY);
        writer.write(SOAP_CONTENT);
        writer.write(SOAP_ID);
        writer.write(CONTENT_TRANSFER_ENCODING_SOAP);
        writer.write(CRLF);
        writer.write(this.soapMessage);
        writer.write(CRLF);
        writer.write(MIME_BOUNDARY);
        writer.write(CONTENT_TYPE + this.contentType + CRLF);
        writer.write(ATTACHMENT_ID);
        writer.write(CONTENT_TRANSFER_ENCODING_BINARY);
        writer.write(CRLF);
        writer.flush();
        IOUtils.copy((InputStream)this.attachmentInput, (OutputStream)out);
        out.write(CRLF.getBytes(Charsets.UTF_8));
        out.write(MIME_BOUNDARY.getBytes(Charsets.UTF_8));
        out.flush();
    }

    public long getContentLength() {
        return -1L;
    }

    public boolean isRepeatable() {
        return false;
    }

    String getSoapMessage() {
        return this.soapMessage;
    }

    InputStream getAttachmentInput() {
        return this.attachmentInput;
    }
}

