/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.vis.vgs.gallery.fs;

import com.ibm.ba.vis.vgs.bundle.DataSetInfo;
import com.ibm.ba.vis.vgs.bundle.I18NString;
import com.ibm.ba.vis.vgs.gallery.fs.InfoBuilder;
import com.ibm.ba.vis.vgs.resources.ResourceManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.XPath;

public abstract class BaseInfoBuilder
implements InfoBuilder {
    private final ResourceManager resources;

    BaseInfoBuilder(ResourceManager resources) {
        this.resources = resources;
    }

    I18NString getI18NString(Node node, String elementPath) {
        String ids = this.getElementAttribute(node, elementPath, "ids");
        String value = this.getElementValue(node, elementPath);
        return new I18NString(this.resources, ids, value);
    }

    String getElementAttribute(Node node, String name, String attr) {
        Node childNode = this.evaluateXPath(node, name);
        if (childNode != null) {
            return this.getAttributeValue(childNode, attr);
        }
        return "";
    }

    String getAttributeValue(Node node, String attr, String defaultValue) {
        return ((Element)node).attributeValue(attr, defaultValue);
    }

    String getAttributeValue(Node node, String attr) {
        return this.getElementValue(node, "@" + attr);
    }

    String getElementValue(Node doc, String name) {
        Node node = this.evaluateXPath(doc, name);
        if (node != null) {
            return node.getText();
        }
        return "";
    }

    Node evaluateXPath(Node node, String xpath) {
        XPath path = node.createXPath(xpath);
        return path.selectSingleNode((Object)node);
    }

    List<I18NString> getTags(List<Node> tagNodes) {
        List<I18NString> metaInfoList = this.buildMetaInfoList(tagNodes, new InfoBuilder.MetaInfoBuilder<I18NString>(){

            @Override
            public I18NString build(Node node) {
                String ids = BaseInfoBuilder.this.getAttributeValue(node, "ids");
                String value = node.getText();
                return new I18NString(BaseInfoBuilder.this.resources, ids, value);
            }
        });
        return metaInfoList;
    }

    List<DataSetInfo> getDataSetInfo(List<Node> dataSetNodes, InfoBuilder.MetaInfoBuilder<DataSetInfo> builder) {
        List<DataSetInfo> metaInfoList = this.buildMetaInfoList(dataSetNodes, builder);
        return metaInfoList;
    }

    private <T> List<T> buildMetaInfoList(List<Node> metaInfoNodes, InfoBuilder.MetaInfoBuilder<T> builder) {
        ArrayList<T> metaInfoList = new ArrayList<T>(metaInfoNodes.size());
        for (Node node : metaInfoNodes) {
            T obj = builder.build(node);
            if (node == null) continue;
            metaInfoList.add(obj);
        }
        return metaInfoList;
    }

    List<Node> selectNodes(Node typeNode, String dataSetsXpath) {
        XPath path = typeNode.createXPath(dataSetsXpath);
        List dataSetNodes = path.selectNodes((Object)typeNode);
        if (dataSetNodes != null) {
            return dataSetNodes;
        }
        return Collections.emptyList();
    }
}

